if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_users_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_users_Get]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].cs_users_Get
(
	@PageIndex int,
	@PageSize int,
	@sqlPopulate ntext,
	@sqlPopulateCount ntext,
	@SearchText nvarchar(256),
	@ReturnModerationCounters bit = 0,
	@SettingsID int
)
AS
BEGIN

SET Transaction Isolation Level Read UNCOMMITTED

DECLARE @PageLowerBound int
DECLARE @PageUpperBound int
DECLARE @RowsToReturn int
DECLARE @TotalUsers int

-- Set the page bounds
SET @PageLowerBound = @PageSize * @PageIndex
SET @PageUpperBound = @PageLowerBound + @PageSize + 1
SET @RowsToReturn = @PageSize * (@PageIndex + 1)

-- Create a temp table to store the select results
CREATE TABLE #PageIndexForUsers
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	UserID int not null
)

Exec sp_executesql @sqlPopulateCount, N'@SearchText nvarchar(256), @recordCount int output', @SearchText = @SearchText, @recordCount = @TotalUsers output

/* First set the rowcount to the total possible rows to return */
SET ROWCOUNT @RowsToReturn

INSERT INTO #PageIndexForUsers (UserID)
Exec sp_executesql @sqlPopulate, N'@SearchText nvarchar(256)', @SearchText = @SearchText

/* now set it to the page size */
SET ROWCOUNT @PageSize

/* Get the user details */
IF @ReturnModerationCounters = 1
begin
	/* I don't want to see the null removed from the aggregate message */
	set ANSI_WARNINGS OFF

	SELECT
		U.*
		, coalesce(mod.ApprovePost, 0) AS ApprovePost
		, coalesce(mod.EditPost, 0) AS EditPost
		, coalesce(mod.MovePost, 0) AS MovePost
		, coalesce(mod.DeletePost, 0) AS DeletePost
		, coalesce(mod.LockPost, 0) AS LockPost
		, coalesce(mod.UnlockPost, 0) AS UnlockPost
		, coalesce(mod.MergePost, 0) AS MergePost
		, coalesce(mod.SplitPost, 0) AS SplitPost
		, coalesce(mod.EditUser, 0) AS EditUser
		, coalesce(mod.UnmoderateUser, 0) AS UnmoderateUser
		, coalesce(mod.ModerateUser, 0) AS ModerateUser
		, coalesce(mod.BanUser, 0) AS BanUser
		, coalesce(mod.UnbanUser, 0) AS UnbanUser
		, coalesce(mod.ResetPassword, 0) AS ResetPassword
		, coalesce(mod.ChangePassword, 0) AS ChangePassword
		, coalesce(mod.PostIsAnnouncement, 0) AS PostIsAnnouncement
		, coalesce(mod.PostIsNotAnnoucement, 0) AS PostIsNotAnnoucement
		, coalesce(mod.UnApprovePost, 0) AS UnApprovePost
		/* (we do not seem to be using this value),IsModerator = (SELECT Count(*) FROM cs_Moderators WHERE UserID = U.UserID) */
	FROM
		cs_vw_Users_FullUser U (nolock)
	INNER JOIN
		#PageIndexForUsers jPI ON U.UserID = jPI.UserID
	LEFT OUTER JOIN (
		SELECT
			ma.UserID
			, count(case ma.ModerationAction when 1  then ma.UserID end) as [ApprovePost]
			, count(case ma.ModerationAction when 2  then ma.UserID end) as [EditPost]
			, count(case ma.ModerationAction when 3  then ma.UserID end) as [MovePost]
			, count(case ma.ModerationAction when 4  then ma.UserID end) as [DeletePost]
			, count(case ma.ModerationAction when 5  then ma.UserID end) as [LockPost]
			, count(case ma.ModerationAction when 6  then ma.UserID end) as [UnlockPost]
			, count(case ma.ModerationAction when 7  then ma.UserID end) as [MergePost]
			, count(case ma.ModerationAction when 8  then ma.UserID end) as [SplitPost]
			, count(case ma.ModerationAction when 9  then ma.UserID end) as [EditUser]
			, count(case ma.ModerationAction when 10 then ma.UserID end) as [UnmoderateUser]
			, count(case ma.ModerationAction when 11 then ma.UserID end) as [ModerateUser]
			, count(case ma.ModerationAction when 12 then ma.UserID end) as [BanUser]
			, count(case ma.ModerationAction when 13 then ma.UserID end) as [UnbanUser]
			, count(case ma.ModerationAction when 14 then ma.UserID end) as [ResetPassword]
			, count(case ma.ModerationAction when 15 then ma.UserID end) as [ChangePassword]
			, count(case ma.ModerationAction when 16 then ma.UserID end) as [PostIsAnnouncement]
			, count(case ma.ModerationAction when 17 then ma.UserID end) as [PostIsNotAnnoucement]
			, count(case ma.ModerationAction when 18 then ma.UserID end) as [UnApprovePost]
		FROM cs_ModerationAudit ma
		WHERE
			ma.SettingsID = @SettingsID
		GROUP BY
			ma.UserID
	) as mod ON U.UserID = mod.UserID
	WHERE
		jPI.IndexID > @PageLowerBound AND jPI.IndexID < @PageUpperBound
		and U.SettingsID = @SettingsID
	ORDER BY
		IndexID

	set ANSI_WARNINGS ON

end ELSE begin

	SELECT
		U.*
		/* (we do not seem to be using this value),IsModerator = (SELECT Count(*) FROM cs_Moderators WHERE UserID = U.UserID) */
	FROM 
		cs_vw_Users_FullUser U (nolock),
		#PageIndexForUsers pindex
	WHERE 
		U.UserID = pindex.UserID AND
		pindex.IndexID > @PageLowerBound AND
		pindex.IndexID < @PageUpperBound and U.SettingsID = @SettingsID
	ORDER BY
		IndexID

end

set rowcount 0

/* Return the record count */
SELECT @TotalUsers

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE  ON [dbo].[cs_users_Get] TO [public]
GO

