SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_User_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_User_Get]
GO

CREATE PROCEDURE [dbo].cs_User_Get
(
	@UserID int,
	@UserName nvarchar(64) = null,
	@IsOnline bit = 0,
	@LastAction nvarchar(1024) = N'',
	@SettingsID int
)
AS
BEGIN
	SET Transaction Isolation Level Read UNCOMMITTED
	DECLARE @MembershipID uniqueidentifier

	-- Looking up by UserName?
	IF @UserName IS NOT NULL
	BEGIN

		SELECT @UserID = UserID FROM cs_vw_Users_FullUser WHERE UserName = @UserName AND SettingsID = @SettingsID

		SELECT
			U.*
		FROM
			cs_vw_Users_FullUser U (nolock)
		WHERE
			U.UserName = @UserName AND U.SettingsID = @SettingsID
	END

	-- Looking up the user by ID
	ELSE
	BEGIN

		IF (@UserID = 0)
			SELECT @UserID = UserID FROM cs_vw_Users_FullUser WHERE UserName = N'Anonymous' and SettingsID = @SettingsID

		-- Get the user details
		SELECT
			U.*
		FROM
			cs_vw_Users_FullUser U (nolock)
		WHERE
			U.UserID = @UserID and U.SettingsID = @SettingsID
	END

	IF @IsOnline = 1
	BEGIN
		EXEC cs_system_UserIsOnline @UserID = @UserID, @LastAction = @LastAction, @SettingsID = @SettingsID
	END
END

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_User_Get] to public
go