IF object_id( '[dbo].[cs_system_updatestatistics]', N'P' ) IS NOT NULL
	drop procedure [dbo].[cs_system_updatestatistics]
go

CREATE PROCEDURE [dbo].[cs_system_updatestatistics]
as
begin

	declare @sql nvarchar(1000), @id int, @full_name sysname, @table_count int
		,@dbsid varbinary(85)

	declare @t table (
		id int identity(1, 1) not null
		, full_name sysname collate database_default not null
	)

	set nocount on
	
	select
		@dbsid = d.sid
	from
		master..sysdatabases d
	where
		d.name = db_name()
	
	-- Check the user sysadmin
	if not is_srvrolemember(N'sysadmin') = 1 and suser_sid() <> @dbsid
	begin
		raiserror( 15247, -1, -1 )
		return (1)
	end
	
	if DATABASEPROPERTYEX( db_name(), N'Updateability' ) = N'READ_ONLY'
	begin
		raiserror( 15635, -1, -1, N'cs_system_updatestatistics' )
		return (1)
	end
	
	insert into @t ( full_name )
	select t.FULL_NAME from (
		select
			quotename(tx.TABLE_SCHEMA) + N'.' + quotename(tx.TABLE_NAME) as FULL_NAME
		from
			INFORMATION_SCHEMA.TABLES tx
	) as t
	where
		objectproperty( OBJECT_ID( t.FULL_NAME ), N'IsIndexed' ) = 1
		and objectproperty( OBJECT_ID( t.FULL_NAME ), N'IsMSShipped' ) = 0
	order by
		FULL_NAME

	set @table_count = @@ROWCOUNT

	print 'Beginning to perform an UPDATE STATISTICS on all ' + cast(@table_count as varchar) + ' tables at ' + convert(char(19), getdate(), 120)

	while 1=1
	begin
		select @id = t.id, @full_name = t.full_name from (
			select top 1 tx.* from @t tx order by id
		) as t
		
		if @id is null break
		
		print 'Performing an UPDATE STATISTICS on table/view ' + @full_name + ' at ' + convert(char(19), getdate(), 120)
		
		set @sql = 'update statistics ' + @full_name -- with no_infomsgs
		exec sp_executesql @sql
		
		delete from @t where id = @id
		
		set @id = null
	end

	print 'Done with UPDATE STATISTICS at ' + convert(char(19), getdate(), 120)
end
go

grant execute on [dbo].[cs_system_updatestatistics] to [public]
go