IF object_id( '[dbo].[cs_system_dbreindex]', N'P' ) IS NOT NULL
	drop procedure [dbo].[cs_system_dbreindex]
go

CREATE PROCEDURE [dbo].[cs_system_dbreindex]
as
begin

	declare @sql nvarchar(1000), @id int, @full_name sysname, @table_count int

	declare @t table (
		id int identity(1, 1) not null
		, full_name sysname collate database_default not null
	)

	set nocount on

	insert into @t ( full_name )
	select t.FULL_NAME from (
		select
			quotename(tx.TABLE_SCHEMA) + N'.' + quotename(tx.TABLE_NAME) as FULL_NAME
		from
			INFORMATION_SCHEMA.TABLES tx
	) as t
	where
		objectproperty( OBJECT_ID( t.FULL_NAME ), N'TableHasClustIndex' ) = 1
		and objectproperty( OBJECT_ID( t.FULL_NAME ), N'IsMSShipped' ) = 0
	order by
		FULL_NAME

	set @table_count = @@ROWCOUNT

	print 'Beginning to perform a DBREINDEX on all ' + cast(@table_count as varchar) + ' tables at ' + convert(char(19), getdate(), 120)

	while 1=1
	begin
		select @id = t.id, @full_name = t.full_name from (
			select top 1 tx.* from @t tx order by id
		) as t
		
		if @id is null break
		
		print 'Doing a DBREINDEX on table ' + @full_name + ' at ' + convert(char(19), getdate(), 120)
		
		set @sql = N'dbcc dbreindex(''' + @full_name + N''')' -- with no_infomsgs
		exec sp_executesql @sql
		
		delete from @t where id = @id
		
		set @id = null
	end

	print 'Done with DBREINDEX at ' + convert(char(19), getdate(), 120)
end
go

grant execute on [dbo].[cs_system_dbreindex] to [public]
go