SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_system_UserIsOnline]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_system_UserIsOnline]
GO

CREATE PROCEDURE [dbo].cs_system_UserIsOnline
(
	@UserID int,
	@LastAction nvarchar(1024),
	@SettingsID int,
	@LastActivity datetime = null output
)
AS
BEGIN
	SET Transaction Isolation Level Read UNCOMMITTED

	set @LastActivity = getdate()

	-- Update cs_Users table
	UPDATE
		cs_Users
	SET
		LastActivity = @LastActivity,
		LastAction = @LastAction
	WHERE
		UserID = @UserID
END

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_system_UserIsOnline] to public
go