if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_system_SampleWiki]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_system_SampleWiki]
GO

Create Proc [dbo].cs_system_SampleWiki
(
	@SettingsID int,
	@Username nvarchar(256)
)
as

Declare @UserID int
Select @UserID = UserID FROM cs_vw_Users_FullUser where UserName = @Username and SettingsID = @SettingsID

Declare @Date datetime
Set @Date = GetUtcDate()

declare @WikiID int
exec [dbo].[cs_Wiki_AddWiki]
    @wikiId = @WikiID output,
    @hubId = NULL,
    @name = N'Sample Wiki',
    @description = N'',
    @applicationKey = N'sample_wiki',
    @isEnabled = 1,
    @lastModifiedUtcDate = @Date

Declare @PageID int
exec [dbo].[cs_Wiki_AddPage]
    @pageId = @PageID OUTPUT,
    @wikiId = @WikiID,
    @userId = @UserID,
    @parentPageId = NULL,
    @title = N'Welcome to Community Server Wikis',
    @pageKey = N'welcome',
    @body = N'<p>A wiki enables member to be able to contribute and collaborate on any topic.</p>
		<p>Happy Collaborating!</p>',
    @formattedBody = N'<p>A wiki enables member to be able to contribute and collaborate on any topic.</p>
		<p>Happy Collaborating!</p>',
    @tagXml = N'<tags><tag>Sample Wiki</tag></tags>',
    @isPublished = 1,
    @ratingCount = 0,
    @ratingSum = 0,
    @lastModifiedUtcDate = @Date, 
    @revisionCount = 1, 
    @isLocked = 0,
    @isIndexed = 0

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_system_SampleWiki] to public
go
