if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_system_SampleGroups]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_system_SampleGroups]
GO

Create Proc [dbo].cs_system_SampleGroups
(
	@SettingsID int,
	@CategoryGroupID int,
	@Username nvarchar(256)
)
as

Declare @UserID int
Select @UserID = UserID FROM cs_vw_Users_FullUser where UserName = @Username and SettingsID = @SettingsID

declare @SectionID int
exec dbo.cs_Section_CreateUpdateDelete @SectionID = @SectionID output, @UserID = @UserID, @SettingsID = @SettingsID

exec dbo.cs_Section_CreateUpdateDelete @SectionID = @SectionID, @UserID = @UserID, @SettingsID = @SettingsID, @HubSectionID = @SectionID, @Name = N'Sample Group', @Description = N'', @ParentID = 0, @GroupID = @CategoryGroupID, @IsModerated = 0, @DisplayPostsOlderThan = 7, @IsActive = 1, @EnablePostStatistics = 1, @EnableAnonymousPosting = 0, @SortOrder = 0, @ApplicationType = 11, @ApplicationKey = N'sample_group', @PropertyNames = N'SectionOwners:S:0:5:', @PropertyValues = N'admin', @IsPublic = 1

declare @DateAdded datetime
exec dbo.cs_SectionMembers_Add @SectionID = @SectionID, @UserID = @UserID, @MembershipType = 1, @DateAdded = @DateAdded output

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_system_SampleGroups] to public
go
