
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_system_SampleGallery]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_system_SampleGallery]
GO

Create Proc [dbo].cs_system_SampleGallery
(
	@SettingsID int,
	@Username nvarchar(256)
)
as

Declare @UserID int
Select @UserID = UserID FROM cs_vw_Users_FullUser where UserName = @Username and SettingsID = @SettingsID


declare @GroupID int
exec cs_Group_CreateUpdateDelete @GroupID = @GroupID output, @ParentGroupID = 0, @Name = N'Sample Photo Galleries', @Action = 0, @ApplicationType = 2, @SettingsID = @SettingsID


declare @SectionID int


exec cs_Section_CreateUpdateDelete @SectionID = @SectionID output, @Name = N'Sample', @Description = N'', @ParentID = 0, @GroupID = @GroupID, @IsModerated = 0, @DisplayPostsOlderThan = 7, @IsActive = 1, @EnablePostStatistics = 1, @EnableAnonymousPosting = 0, @SortOrder = 0, @ApplicationType = 2, @ApplicationKey = N'sample', @PropertyNames = N'SectionOwners:S:0:5:', @PropertyValues = N'admin', @SettingsID = @SettingsID, @UserID = @UserID, @IsPublic = 1


declare @CategoryID int
exec dbo.cs_PostCategory_CreateUpdateDelete @SectionID = @SectionID, @Name = N'Wildlife', @IsEnabled = 1, @ParentID = 0, @Description = N'Interesting Wildlife Pictures', @SettingsID = @SettingsID,  @CategoryID = @CategoryID output


declare @PicPostID int
declare @PicThreadID int
declare @PostStickyDate DateTime
set @PostStickyDate = CONVERT(DATETIME, '19791209 12:38:01', 112)
exec dbo.cs_Post_CreateUpdate @SectionID = @SectionID, @ParentID = 0, @AllowDuplicatePosts = 1, @DuplicateIntervalInMinutes = 0, @Subject = N'Ready for the chase', @IsLocked = 0, @PostType = 0, @EmoticonID = 0, @PostAuthor = @Username, @UserID = @UserID, @Body = N'A picture from my backyard!', @IsApproved = 1, @FormattedBody = N'A picture from my backyard!', @UserHostAddress = N'000.000.000.000', @IsSticky = 0, @StickyDate = @PostStickyDate, @SettingsID = @SettingsID, @PropertyNames = N'ContentType:S:0:11:Width:S:11:3:Height:S:14:3:EXIF-DateTime:S:17:22:EXIF-Model:S:39:13:EXIF-ExposureTime:S:52:5:EXIF-FocalLength:S:57:1:EXIF-ApertureValue:S:58:5:EXIF-ISOSpeedRatings:S:63:3:EXIF-Flash:S:66:1:', @PropertyValues = N'image/pjpeg42528307/15/2004 09:08:18 AMCanon EOS 10D1/5008f/4.54000', @ApplicationPostType = 64, @PostID = @PicPostID output, @ThreadID = @PicThreadID output


exec dbo.cs_PostAttachment_Add @PostID = @PicPostID, @UserID = @UserID, @SectionID = @SectionID, @Filename = N'Cheetah.jpg', @ContentType = N'image/pjpeg', @ContentSize = 20558, @SettingsID = @SettingsID, @FriendlyFileName = 'Cheetah', @IsRemote = 0, @Width= 425, @Height=283


--	Commenting for now until CFS is worked out for this
--
--declare @ptr varbinary(16)
--select @ptr = textptr(Content) from cs_PostAttachments where PostID = @PicPostID
--writetext cs_PostAttachments.Content @ptr 0xFFD8FFE000104A46494600010101006000600000FFDB0043000A07070807060A0808080B0A0A0B0E18100E0D0D0E1D15161118231F2524221F2221262B372F26293429212230413134393B3E3E3E252E4449433C48373D3E3BFFDB0043010A0B0B0E0D0E1C10101C3B2822283B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3B3BFFC0001108011B01A903012200021101031101FFC4001F0000010501010101010100000000000000000102030405060708090A0BFFC400B5100002010303020403050504040000017D01020300041105122131410613516107227114328191A1082342B1C11552D1F02433627282090A161718191A25262728292A3435363738393A434445464748494A535455565758595A636465666768696A737475767778797A838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE1E2E3E4E5E6E7E8E9EAF1F2F3F4F5F6F7F8F9FAFFC4001F0100030101010101010101010000000000000102030405060708090A0BFFC400B51100020102040403040705040400010277000102031104052131061241510761711322328108144291A1B1C109233352F0156272D10A162434E125F11718191A262728292A35363738393A434445464748494A535455565758595A636465666768696A737475767778797A82838485868788898A92939495969798999AA2A3A4A5A6A7A8A9AAB2B3B4B5B6B7B8B9BAC2C3C4C5C6C7C8C9CAD2D3D4D5D6D7D8D9DAE2E3E4E5E6E7E8E9EAF2F3F4F5F6F7F8F9FAFFDA000C03010002110311003F004B8B99C5D4A3CE7C6E3DE9BF6AB9ED33FE74970BFE9728FF006CD285C0E6B8DB676217ED7723FE5ABFE749F6DB9CFF00AD7FCE9AD8C5474AE3273777247333FE74E5BAB81D666FCEAB0393CD498E28B8C9FED938FF0096CFF9D385ECFF00F3D9FF003AA258EEA9109340685B37971FF3D5BF3A05DDC7FCF56FCEA14426A658F03A52B85C5FB5CFFF003D5FF3A517971FF3D5BF3A3C9EE4E3EB51C811472C07B6695C2E3CDF4FFF003D9BF3A4FB64F8FF005AFF009D57F977AA96E5FEED38005DE3CE193EF0F4A682E8985F4FFF003D5BF3A4FB74FF00F3D5BF3AAD9575DC8E197D41A41D69816C5EDC631E6B7E741BB9FF00E7AB0FC6A01C504D20B8F6BAB8FF009EAFF9D1F6BB8CFF00AE7FCEA2269BCD0172C7DBA75FF96CFF009D20D427FF009ECDF9D5570D8351856EB40AE69AEA13633E6B7E741D426FF9EADF9D5019C52856A18D32D9D427FF009ECDF9D27DBEE319F35BF3AAFE5B5288C9145C073EA5720E04CDF9D4916A3727ACCFF9D57F209352A438A2E2B1686A1381FEB5BF3A6B5FDC7FCF56FCEA1D98A77979145CAB01BEB8FF009ECDF9D345FDC7FCF67FCE830FB537C9A04585BEB8C7FAD6FCE8377704FF00AE6FCEA25402A655145C7A0AB71704FF00AD7FCEA4FB4CE07FAD6FCE9B800534914AE2124BDB81D256FCEA237F718FF5ADF9D122E6AB3290D4EE1727FB7DCFFCF66FCE946A1703FE5B3FE750247BBB548B013CE28B8128BCB93CF9AFF9D48B7571FF003D5BF3A62454F2B8E052E60D053797007FAE6FCE9AB7B705BFD6B7E74D65CD204028B81696F27C7FAD6FCE97EDB3F4F35BF3AADD05358FBD1711685F4FD3CD6FCE9EB7931FF96ADF9D671622A546A622E9BA9BFE7AB7E74C3773FF00CF56FCEA02DEF4D66EF48562C7DB26FF009EADF9D1F6E9BFE7AB7E7541DCD315CE4D3B08D2FB6CD9FF005AD527DAA6FF009E8FF9D662B9A9F79F7A5A8C5B880FDAE4E3F88D31A220568DC20FB449F5A8B62D17119FE4B114D301F4AD2F2D693CA18CE28B8CCE5871D453CA7CB570C40F41479591D28B819FE4E4D4C9055910E3B54CB1E2936088A283DAA45504B11F713EF363A7D3D6A53F2A31CE0E29D0451CF3AC7193E5C69BCE3B9FFF005D2B9455BAB70B1B3E36F19099C331F7F4A883DA45E5B790D1B919619CE0D477B7B1DB5E2CF7D26C817EE2BF01DBFF00AD50CDA85ADFB6F8654057F891B22AD26D5C86D6C589226289B2633232F4200DB9EF59175680B2BDB12202791C839EE735A49394007504751CF14EDF146980CA559B028032EDE467731088F9217F7732BE33ED56ED5DA766492331C80FDD3FE3DEA593CBB3632100C6072CBFC39FE951DC4CD736BB0E1ED98F0D080A78F7EA285A85EC58488CAC523F9D87040E48A1ED9D1F6BA9523AE6B0E7BB5B2555B390479E91C673CFA93EB5D369D65245669F6872F2B7CCC4F6CF6A725640A572AFD9CFA53C5B13DAB48420538443D2B3E62CCD3699ED4C6B4E7A569B28151601345C0A22DB1DAA45B51E956C20A7EC145C0A4D0F3D293C9CF4AB9B0134F58C53B81485BD2F93ED57BCB03A8A6BA80295C65231E29314E9DF1558CDCD315CB1B41A0C63151A49922A7520D02B9098F9A4C1AB41334BE48F4A2E32A9069369AB9E48F4A72C00F6A57114BCB38E69A60C9E95A1E501DA9A545171D8AB1DB815298C014EDC052839A570222B8A61426ADECCD208FD68B8153CB348C8455CF2C67A535A3E29DC0A0739A420F7AB661148621E99A7715994B6927A715284C54E21E7A53FCAA1B02BE29AC0E2AC98E9A62A00A6D193DA916322AE7943A6297CBF6A7711504673D2A6D952797CF4A9760A10C75CBFFA4C9FEF5301E29D703FD264FF0078D37B0A091437BD286E314D00934ED8715230079A7645370690A9A0078229EA7351A21A982714AE3109C2E7BF6AB96532D9D896942F993B6D00FA55472B12177E481C6074AA734CF79613C3190D360ED1EF8E94D0333F5CD1E6F165EBBB5C082D6D8ED5C2E416EFC54B61A1DA69200871E6852C65917E773E98E9B7DAB57C3FF67BBD2208A165478C7CCA4FF10EB9A9A6025BA11A43212876B15E4127A13ED5B393D8C925BB30E0B88AE6768E68DD2771B954A1E7E9FE1526A32C11DAB8DBB7611963C6D26B62F6C45DD8B890180720163B5D587753D8564DFC534BA56D943306501896C82474CD4752EF632AEAF1FECB0D9F9626F90EF23A03EF4AF7CB6DA004689A3B8E9823827B7357B4AB4B87592E5A18D58C580B27453DF07BE4564EB48EB6AACCDB892576A7407B1AD23D887DCC25BC58A759A60AD939603A035D8787BC430DCA7D9666C49BF6A1C641F627D6B897B3721951F1205E98A6A493C1286B79024831E681DEB49414958CD49A67AC9E3AF5A4CE2B92D23C52162FB348FF00682831BDCE181F43EB5BF06AD673461BCE553D083D8D72CA0E2744649965C934D0A73528018641041E8452118A82C6E714D32629587150B034D12C955C77E6A55718C5545CD4EB4D81396E2A37E452F3DE984F3486549E32D5585B9CD699506916314EE2B14D206039A99626156B60A508052B8EC4488453C714EE290AD0000F34F1D29AA94E230290C6B3544D4F63CD37AD3022DBCD488B8A5228CE28024E298CD834D2C71D6A17639A2C22532544F3E0F5A8598E2A060C4D3B08B3E764F5A915B3556343DEA6070281960114E38AAEAE01EB4FF338E690126050454624A5F307AD0018E696985FDE9035311260645495086F7A9375301275FF0049933FDE34E58C114976765CC9F5A885C6053B129968201485455749CB1AB0BC8A96AC340A8334A53A53C0A0E6A4A1AA805388CA900E38EBE940069CA3340CE0753BCF10D9EB11D88492E269DB6C5E92F3C62BB4D174AD4B4FD395750319BC662CE01CEDCF6FC2AEA0DAF1ED821795640D1BC9FF002CFD70696EB584B36297967343C7124637AE7D78E6BA749C7439DBE591CD69D0B69BE229A0967321B897785553803D6BA89EE21B62248D1B08C718E3FF00D75C45FCA6FF0058FB458BCA3B1F317A9F61DAAD5C6A17916D82E1D815E7630C83F85572AD0573A1FB53EABE641736ACD6814E597827DB155EFDA3B2B0B58F4AB78FCB2E17CA99492C0F5FC6AF787354B8BB85DE795088C60285C607D2B4354BC10D9B7D99E1F3FAAA3AF39FC687105238AD4B584B0D424B3895E442818EF1CC471D3D0D66DD0374F0430179377CCCD8FBCDFF00D6A7EA32DE4D697536AB6E04ED2E102F157F47D359FF007F67BD51970CA5BE550053B585729CF612D8333451EE95D4281226467BF355AEAC1F528D8A5AC505C20C3CBC843FE35D558C52DDDCB98D800BC15403F0CD41757B78D24315C59ADBDB08F2F22F196CF03D8D2721A47032691398A578E32FB3EF3C6739F7A79D46E20B2160969E517018C849DCD5DF47A15B456F7296F3AC535C166C13C938F4AC96B275B9D3E3D4A1799F67EEE68B8C30E403ED494D3DC391A652D275AB9B5890C4E6E6DD066484F0E83E95D169FAC5AEA8B9872AC3AA37515492E85CE937B34FA18468C907CA3B4BFAFBE4565694B676F6C751B4B898A8936BEE5E63CF66F6F7A96948B4DC4EBF34D65CD66D8EB315DC8F14988A543C863C1FA1AD45248E958B4D1AA698D588D4A131DA9C01C52D48C8DBA544C79A9586693671CD00460E29C0E29DE5F34852801C1B22919B8A02538AF1400D534FDC314CC628340C9378C534B668099A5298A04466907029F8CD0578A06309A073415A3914C4230A8D93BD4B8CD05734015F60CF4A0443D2A5294BB714C56212A14544CD9E952CBE955FBD218A09A1988E29E178A42BDE9A1323DC4501C8EF4EDA4D288F9E698840C4D38350168DB4C63C354B9A8953A54FB2900DD401372FF5AAC2227D6B4EF221F6973EF4C48FB53E622C528E32AD57632318A71807A50062A5BB9490FC8A51CD300A701EB523B0E23DA941A5C0C530F1486480E6A2B8B686E71E702D8E9CD26F229324F4E6A93684E37122B7B7B7FF00551283EB8AABAA69C2F503A01E6AF73DC55E553DEA40BC6285269DC4E2AD631BC3A234D44C3705917B81EA056AEA7F658E62ED724246809279CD52BEB168AE16EE3241CFCF8F4ADAB7D2A39674B891D5931928791822BAD49495CE769A671B71A75D6B6AEB6AE02BB111EE1D7DEA7F0FD85DD8E992DB5D4A762E77056FCB1FE15D07F68DADC199910ADBD8F0EFB36EDF5C7AFF00F5EA9594F6DAADBC973653BB47E76CF2B1939EC2A5B1D89BC3F1DAD8EFD32CC4FF006B98198978F231EED4FBBD392082D6D6F237B93773124AB7C91F5600FB0C56E69DA14F0EA897C7517F22384C5F66D831B88E4E6A2D3B4D9748B1921BE9967DD34D229EBF29E8BCD66CB4735068309D71759FED1FB4460958D14E5471D33F5AAA0CD61A95CC56F7AF2DDDD46D34113608561D31FCAB4EDFC32B1D85DDA58486179E43CB1E109F4F4A5B1D16DF4CB0B2B9D71D5AEF4F62C2656E8B9E33EB8A49976337FB5B5CFF00845B75C58ECBC8E65E3CBC17527920550F12EA16364458B426096ED01678B0021FEBCD6CEAFACC1A84A6C34FBA5370F133C6DD9811D8FAD7257963756BA3B3EBB0B3CB137991316CB01DC1AB8ABEE44B45A115A4976FA7B2B448F25B9F9E2DBFEB17D41ED5A961A95EDA9665B29E4818823AB6C1ED9E7EA2B134ABCBA5D52DD22CBC53A95DA47E22BA4D32D359BED21835C2DA5CC539F2B7FCA244F43F8D5C888BEC69E9FA98BA9A6B7995619A22303770E0F422AFE6B9FD42582EF595D3A7856DAF7CA1E5DC20CFCD8E98EE2AE471EAB0A5B4C1E1B987708E648987C87D413FC8D6328763553EE689EB4A0E05453CD25BB48CD06618C64C9B80C66A18F54825F30A248EB1805D82F0B9FAD438B2F991681E6A5500D508356B09D8A24E03838DAC4024FD2AD47796ECE515F0CBD430231F9D2B31A64CCB8E6A23C9A955D1C655D4FD0E69850D2023239A518A711E94D02802452076A46346D23AD00734002A934A452E405A6EECD00308A319ED4ADD68E940098E69702928A00080298C69DDAA376C503229066A3F2F9CD5802976F14C442179A714CD3F6F34EEF4AE043E5F3D29760A908A653019B4669703A77A701DE91863DA980A179A9B150A9E952D005AB9C19DFA75A6A802993CBFBF71EF5189093C54816490453703B0A62E7D69D400B8C503AE690364E29E05200269A69F8C8A631C1A00615A923419A66E1F5A9236C1A604A22C738A7AA734DDF4E0D8A9024F2D48E4022A0B789EDA695DA6262C0C03FC233CD48D3851513CA240475AB849C59328DD1A97D3DBC166FBA2477927198801863D87E1C5642697FD946DE3B2844925C3B3B246DC29FEF1FC4D4967F679F463792879A5C6D254E36919E4FD2B3D627B6D224787516BAB89976AB31C84C11C7E24D7433246DE91A76B565E2A9E69E7DDA51B5023C1CFCFDF3EF9CD52D7351B2BFD560B94BEDB1596E478C3705CFAD5A8B5DD660B3D0E292C7CD92E9D92EDD7958C038CFE350DEF82AC66935068E5922FB7105C0E42B039C8A8D06881BC3DA8DB586AFF0062BEDF35EB07872794FC7D69977359C3A5DA69DE2360B7573008E420F7CF5C8FC2B56C7518A6BFBCD1B6BC725842A44C7B8F5C555F12785ED7C496704CB74239E3C05941CA91DF8F5A4B7D4A7B6873DAB691A27877ECB7BE5CA059F47CE59C9F5AC1F13EB10DF5C8B28D99ADA787CD47AECB51B2B2BDB71A75F453C88A014B84E84A8C726B82D767B44464B5447368BE5AE3A85CD690D5EA44B4467E99A8DC581FB4C30798219401C7F0D761AF5ADD697796FAB4B3BC96B7057621FE0047439E95CE784AE648FC411C1B40814055DC39CF515E85A6EB169AE7DA525B261E4BEC7327CC8ECBD0E3B554F4628EC67DFDC5B5A59C1ACDEDB896488EC56C618E7A5525B4B5D28CDAAB5D6FD3AED77BDB9072324115634DBA6F10CBA9E8DA95B8F2636CC781B70A0F407B71D2ACC7158DED9DC68B2C7B628F312173827B8FD0D47A8CCBD61EFE2BCB6D4B47CDCD84D105F29017403B823DEADDD4769A7DBADA245756D15C480B490364C0C40C707F879E956F4DB68B49D320D3ED2F55A71CA993B8CF3C7B5646A9A95FD978B6D51B7B5B4EA14A81C367AFF4A7ABD0362D148A38A19AEAEAC9DED5CC7348611B4E4FCA7D55AA88FB55DEB318D4EC8E2605567809F2A5F4C81C63DEAEC1E18963D56FE792747D3AE410F191F31CF3F811EB53DBC4FA1E8D8B79CCF6D14BBC9938D8BDC7E54AE90EC63D84516976BA949736D2A796E7947DD191EAA3B5225DCE218EF21D5A31607FD6090ED68CF7031DEA5B5D266875A7BF8E78E4D2650CD23337CA54FF00091FD6AC0D074A78E6D3614664BB3E629F301DB81C15A7A06A2C77D732DBBCBA65C0D4230D83E6385703DB8C1A6EA5A86A563046C823FDFA82124902C919F4F435560D3A0BBD16E34AB59E4B736F316679C6DCFB53A3D1D7FE11C957565FB4CD01324262972FB3FC2959751DD962DE5BDD39609269A7996E47CD1CBB4F967B65876F7A74371AFCFA8086E6116B6DD4CB1ED6C0EDD7A8AA31AE9FAFF87440CCD67F6020192425B19F5AB2962D3F84E2B317C27677C477119CAC7CE4293D40A2C82E3EE754D5A4BD6B3B0B6864741F32C8E1587BFA114F9F5B6D28DB7F6A6E1F685E152304A1F720E0D4165A7AE97A5B45ADC890C924A5609B3BB008EB9A7E91A56A50C57967A8471DDD8842F0B487702FDB69EBCD2696C1764B2789F4D8EEC5A99773671951C67F1AD5DEA76FCC016FBA0F7AC5B5D034BF12DA1B895FCABB5E2E05B9CE08ED8A92FADECDEC6D9ECF54FB29887943ED190AF8E30C3B7D454B8C7A14A4CD7071C1EB4A791596A93E9125BADFEA3198EE07CA24CB007D9FB8FAD5E4BB8BCCF2653E54BD831C071EAA7BD438B452921E4F34C3DCD121C37355CCDCE39A928B008A5CF3D6ABAB1A76F38A62262C01A073510249A900E0D0038E3150B362869874A88B67BD003D6434F23350F43D69E1F9E6801C3AD4DC5434FCD301D38FF487FF007A9B1E41E6A7953371267FBD4CD98352C0941E3A519ED8A44523AD0D48072AE4E69F8E688D491D2A464E69300032306A0950E6AC27030695D45032AA46714EC106ACAA80314C6033CD17019D0734BBF148C7B522A96E31400C6259A9C8BC75ED4FF2B1D29C0639F4A6232BE1D6BE93CD79A25DC610F9CC6267E777FB3FD6BAE974CB7B70B25AC0224072598632704671FAD71BA0E985FC72B085CF92C67638EABDBF535DF788343FEDED3C5B35C496C3A931B727DABADABA39AF6763060D6EE743D2AE2496D1A7B787CBF2E4439DCA4E0E7D0827357351D3751BBF13E99A8DBDDF97A7C11B1962CFDF27B7BFFF005AAED9DAE99A0DAC3A4B48844A71B25392E4FD6A86ADAA5CD9CFA7ADADBF9B14B78217E3F87D6B26FA16B7B9655A19FCD6312C734A0C6DB800C4678F7C563697A5CBE1EF0F5D5A6A1A8C4A1E6668E41CEC07A67345F68D7F3F8DE1BFFB428B582321533C9CFAD64F8A7EC32BAE8B7972C82E3EE92DC29ED537D6C6965B94346B2D7ED6E6EE5BEB8335A3A315C3E55BD08AE52EACE3B0967B82FE7C6D28E50F519AEFB510346F0DF96672C90461496EFC631F957156C2CF4DB3B71342675B99B72397C0073C1FC2B683329A2ADC5D49A76AA8E90831899081E8BC57A444B6DA5585D4B688DB9D8CEEB9C83C76FD2BCEEF524373249B331B920499E33E95ABE0CBBD404D3C378E5EDD863E639C7A62AE6AE898BD4DBD17C42DABE937372D01B77B76C4AC98C9152A4BA3EAB6536A96B23E123F9B2C46C2BEA3E9489A86996D7A74D5F2ADCDD0CB2328058F4EB55ED74DD3B46B6D42D0CAE6DE6CF99BF82148F5ACF42CCCFEC9BCB8F1069DA869D379F68A54F9D9F957D456EEABAFD9E9DA9C66E1049B9C246DB47CA08193F9D45A6FD920D0123D3AE269E18119B2B8F9BD4566D8C3A6F8CADB6BA4D6F716980AA8776F04F4E68DF70D8B307F6C0F1A651E4362E85B27EE320071F8E6AB6857B73A95EEAD697D215B6DA49575FB849C7E1C5696BDADC3A1CF6B67B2691F685600E3E5CE07D4F1D2A2F105CC3A2AA4D25A37FA592594800C800EFF009D3F90BE64763A70B7D22E348B9BC8E7B39A5C452236D600F5FC8D36EFC297B6DAA59DE5B5C20B588A06677DA500EBFA510F87E1D5F473FD9F388CDE49E7C4921E17FD8CFA56BBE8B8F09DAE8BA8DD3FDA9D98E51B704C7F0FBF14376028789740B8D6E6CE9D3A2C609055DB19EE08F5ED4ED4AEE2D13C3F0A6164962511B11C2F99D48AA3AF59EB5A6EA56C34B4B86B745023F2F90A475DD5A3A9BC72AC5A7DDD92CC6584CB72108FDDB7AFFF005E8B6C3BEE2E9F796DAFE90D7935B4690CE3CBB95C60EE519C822B3BC3FF00D99341A9E9BA7B4A1E6C9025382A3A641A668FABD815FECEB02D6A9139902B8CF99EBF8D627F695B689E2476B189F2FF002B876CE33C9C53484D9BF616571696171A7EBF189EDA3917C87E186EE9C7A54BE0FBB9AF46A96F7437C1038284F38E7A0AC2D527D604505B1919E2925323927B13F2D687886FEEB42B4D3AD6CC04927F9DE58C63CD6E98349ABE8099A9A578753C297977AC5FDDA7D989202827241E9F8D3F58D2ECFC470C131BB4B667C9819F80C0F3820D696BF79611E81036B303219B69921EA738E9587E21D2A6D76CEC6F34184DC59247B046A798C8EC6A2376EECB764AC6869DE1B58342FECCD5DD2E72E4C6AA7A71C6D35CFA59FF0068596CD3276B97B262B25BDD9032B9E307F4CD743A847A969BE0B8B7922F60886E2BC95F7FA8AC9F0D8B7BFB0BABF8D648F506530CC54E5598F3B80EC6AD5C9D0944B3E9D716D63731B08A75FDCBBB6E653DD18F7F6AB70C6B28F31082B9C7D0FA565F871DF52B0BCD3F5572522702391F860F9E304F4356B77F67DD4921694318F2E5871291DCFBFD2A651BEC352B6E5C75DBC52A2669967731EA36B1DD43F72419FA7B55B5502B17A3B1A8C550292404A1C538800D3881B68B8EC679439A76D38AB455476A4DA09A7726C4489DE97CB3926A70A29AC79E9487618074A931F4A6E7DA9D9F6345C0B131C5CBFD680477A75D28172FEB9A62F1480954645214E693CD03BD44D3F3D6901723031CD296CD411C9BBBD59500AD4811E48ED4E1D326860334D60476A63240411D6A3939A4DFB4542663BA9012AAF7A78E075A623E69C7819A603B7629C0AFE350673CD1B8834C0D5D0ADE04D60DD08B370F188F70ECB9E6B5AF2FE4B6D4E18595C24A386ED9F4AC4D1A461A944036DDD919FC2BA10D2BC29F688D4CA879C1E338EB5D14F58984F491535DB1B1895F5C9AD1AE2E2CE22D1AAF24E391815486A73DCE950EBE917FA20B43249005F9C367B7E19ADF8EE524455C81214DC50F24561B6BADA8C1736BA4419BBB6915648244DA0A6EC363B74AA6884D99FA958DC6AB3695A86997EB12A389083FF2D2323A7D6B3FC43E078B5AF10437CB7450643491819C81E957FC596F713D9CD69A2AECBEB129208938250FA54F66B26A7A769F7F74935A5D21CC8A38CF623E9DEA2CD1A5D3323C5F626FA18F4E455093295F97AA9C75AE2EE34BB4B5892DF02ED6D93CC5883FCCC475C7B57416965ABC7E38B9B9BADED68A8F96278C1E80562EAF1ADA6BE358809102A32AC67839C73571BAD09656D434A0967717826005E32491C3DD147F5AA5A26B8D63AE881E3730CBF21206707B1FA53AFF005BBFBED1A17D84A481B7B6CFB9CE00CD526B98ECD50C9F78E0647AFAD68B54475D0EAB59D092F7518756694948C8F3554761DC54F7CA2FAC2EA396E522B795C057738E318CD658BDD7EF22B71A7299202764802E793D8FD6B6F56F0FD9EA02CECEEEF12D2E429550C782DE959BD19A2D4B3A1E976FE1CB78ECFCF374647243A0E1B8C8FC2ABC9E20D1ECB5AB9D22CE116D2DC101AEA2007EF38E2B4E1D31747D092D62B86BAB88236D8EE3AB76AC8F0FDBC7ABDDDC4FABF87D22BAB4019A7C101893C67DFDE9770EC4B7D6B677EE8DAF44512CF28B71BB0255CF43EF5767D3B4EF10DB18EE4BB59DBA0104E9203818E99EB9E39CD45ABD81F12E98F691DC4093ACA194AB64601E722A2F0DD8368D66F65713C724F21690C6877051D3F5A57D370EA4767FD85AD4B069D6134B6E2C1BCC503237AF703F1A83C49A16A77779FDA96374924510070250AC8DDF1F4A93C39A5D95B6A77B7D6BF682F1B14F2654C1427A8E6B1D3C4B7336B3269F3DAC714577218E5403919E3356B7D04F63A8BFD697FB152FA1BBDCD101E6188F0CDE86B9FD0B5F4D535D7796D104AD1ED2E0E495F4AD15B6B2D1F4BBA8A183302124027717247FFAEB95B2D7AD2D6198C1A7C76AA23DA65C92C4E7A7D688A5606DDCB7E22B9D3347D452EAD2029713820AA9E179EB8AA57EF0C3622F4DA896F09E243CED1EA455799E3BDF2AE268D58E3E42C3902A6D12D75FD5F5178ACE3FDC0CAB17C040BE955D056D6C58FED5B89EC21BCB9CB36CD8703A2D767E0ED574FF001487B7BBB08DE6B101E26917705F7ACCD3A0D3F4F8B568EFA286E6C6381564C365C3F7503B63D6B47C03ABF87A79EE34ED1ACE4B492552EFE69C99074E0FB565269A7645A4D136AB7DE1CF165E49A0CD76D15D893E495470580E40A967FB37827C31245A7B34ED1B0DE58F3BCF73E82B3AFF004BF0E784DEE3C416DBEF6EA29309117056273EB8AD3F0A6B56DE30D2EFBEDBA6AA942166DA32B2FA7E22A7A7915D7CCA9A0EB9FF000915ACFE7C2C6EED54BED46C0954F6C557B6D3523B49E2D190DADDDD7CDB246FB847518EDDEB5E48742F08E9926A16D6D2C693615DB92DF4E7A572F269DABA78CACF59B1579ECA791641283C053D41156ACDE846BD4B7AFDB1D5B4B5B5D3AE639F50B33FBF8E2E093DCFD6B3B5DB7D4ADBC37673CB231B8894ADC2F7DA7A13F4E2B7E5F0FC3A7F88E6D5AD2E59257472F1638763D08AE56DFC49773E87A9B6A4A267B77017230DF376FA5545F625A26F0FDF3DAD8EF88A4D1AB0F362CE1933DC7A8AEA8B64641041EE2BCBA19923BC33C25918C7B401DF8AEDFC2F7E750D12367CF9B09F2DF3D7D8FE5535A1D5174A5D0D81ED4E66A8F2474A0E4D739B067340A1412715288F02810DA5D99A0F14A5F140C615C1A9368A68352D0017320172FCF7AAEF2FA1A7DC2937327D69B1C059B34088FE76E681192466AF08297CA0BD45201B04640A98B10314A9B547BD1919A5601F10C9C9A74D8519A6070B514B364E3D6818D6248C5445315281918EB4EF2C6280238F83D3A54ADCFF00853400BD29AEF8E94C43C7140E6A2CB11D2A48C7140C961644957CCCEC3C363D0F06B66C6EA4F23ECDA8005E16D89321FBEBD89F7F5AC16E98AA179AB4FA56B50482E91ADE78BF7B6CE795238DCBF5AD693E86551753B749ADD26F3BCC019B081FB91EF50E9BE22B3BEF115DE990C615EDD465F6FDF3F5AE326F10DB5C27EEE5F941CEC6E952784F55B08B57733B6C9A51B52527F435BDAC62F53B3D41F478B5BB53732AC77F3218A2C923CC51CE0FAF3546E2EAFAE6C2E97ECED6D77133A46AFD1F03E520FA1AB5A868F65A94311D5512736EE1E3941DA50F6E959FE32D3754D52CA293489C9B8B5932555B1BBFFD551BEE52D0E55B50F1341E0E92EA4B226F5AE7660A7257D715CC6B773A8CF70AF7615608A2236018CB1EB9AF41F195F5DE9DE1933042D3A001C0FE162393F4CD79B6A135CEA36B6324A1802A5A76ED9E9550091A87518A5F07D9DBEDF2E275628578DEC0F71ED5CB5F486378B31799CE7A64576BE20F0C496DA569CD6E36456B0950879DE4F25AB8A8EF50CFE5EE0029E86B489123ABF0DEBCFA3BBA24619AE542A6EECDDAB46DA2FED011DE788225B7BAB590B2956C71DB35C837DE1872B9E50FA1AE87C3367A95E437125DCC93C5293190CD90D9EDCD4CA3D4A8B7B136AFFDBF75AEC171A50F3ACF2A4286C023B835D27F6823DCB5A3DCC693C9C4B016C15503B562BDE59F82EC3CB7B59D52472323E655FA7B54777A5699AD4B0EB918613300CBB1F6EFC7AFE559DAE5DCA3A56916F6BAFCB769A84A0C2CDBA3DBDC9E01F6ABDA8C925C59CD36864A5D79815C85DACD81CE09EDDE99AA5BA6A7A2CD269972BE79C066539248FE1F514FF0D5B4ADA1BC17D94BA248DE5B2C06287DC097C34755B5B6B86D69CAC23E742CE0B835026A316A1ABED55D3DDC370E9CC88A3F99AAB2DFC3A45A3D9EADA9477B34E580F2C72063039AE744367620DDD9472BC918E0B1E41FA55257D5937B685FD6B56BFB7D51E3B58B1112183B0CE47AFB564DE5C4176DB5D17CC1CC687804FA9A9E0BABAB9479EF46DDCDF2A5269569A73DE4D777123315273FE02AD2B225B26D2B45BBD4176DDCCB146C7064270A9ED9AB16FA0F89B48BB32E8A64BCB657F95E16DCADEC7D2B7A2D76C5F446862B485648F263594E79FEF1F7C5667873C7F71A64E967736710B432658C430464F24FAD47BCCB491D47887CED2B4C8AE2DF444B99EFCA4776107723A63F3E692C2C345F075D5B3D9D8DD4D7B7E044D86DE20CF5CFA63356974EF13B6BF760DDA49A65D40ED6F28E3CA623E5F7CD63F82BC35E26D2FC4928D409162C87CE76937093D08FC6B1E96341963E23F0F68BA95C68A6092EA0B9B826E26940237938031E82BB89EDC69F6F3C1A7D8A5BC4B179A8D128019BD3158CDE09F0BC97726B731282197CC70B3031E47AFA64F38ACEF196A3ACAEB76375A4CD23DA48AA63687E64624F20D3493B584D983A16AD737FAEC9A7EA05EE2DEE03096193900E2BA0BEF13D968F716FA76C65C80802F488638FAD2DF4B6906A45608218AEE66392060B1C76FC6B1BC41E1F92FF0057B5BFF316357DBE72F52AC39E3D6B5D1B33D51575ED4F52D1A7B30F70670D2962DEA33F7693C47A85ADC0934F28A924986700609EF9A65CEB3677B25C9D460C4769304898752DFE358372D1C9AE4F2990BB483F76A7F8463BD546226CA7716AF145FBB3B9D09DA47B9AE8BC237D22EA11DA30052788EE23B38E4572CD24C6458D49C1EA7D4D59F0FCF3E9DABDBB9070D305627F235725789317667A981CF34F001EBD69BB81191F853D4015C07607CAA687930BD29C064D32451480891893CD05B9E68DB814C3D69812E40C53F7D5739CD49834EC05E9A1FF004873EF4E8931C62ACCC83CF6E3BD34145A421A463DAA1724D3DE55CE01A6F0690119908A40D9EF448B9A45434008D21CE3269C13710694444B722A60981400D45C53E4E1698C767348599E90C89893C0A9228B3D45288C0EB5229C0A6215A35518C649A66DDBC0EB43B9FCE91549E4D00237033597ADE8316B96AA864F2A68CE63900FD3E95AB202062A3DDB0534ECC1ABA3CD4D94FA6CCF6E67732038C49DAA9B4DAA59DCF9D1B160873802BD4B5CB04D4BC372CF0420DE4238651C8C7F3AE7B4AD0A5D5A2F2EE6292DAEC8CC41930B20F635D5195CE792B09A66BD77AD5FA4297B2C42F22093AEEDB823A32FBD74DE19D3B5DB0D7D436A26F6C5A3227278C11D38FAF7AE0757D32F34298CB3C1246AADF2C883806BABD23C4F2DF6A76CB607EE400C8F23E031F7F5A25DC11BB6DAF5A6A973A8D9CAA21B8B7C8314BD197D79AE3E4D1163D46783507C7DB58082257FBA00CD761AB68D67AD595C4823482F2EA22BE60EB91DAB05BC33A85D5FE9922CF86B04D92CAC7E5276F51509AE8534C4B9B6BB1A6E99A55FCD3ADF349298642720AE30326B88D5B429B47BA5691159F682CEBC827BD7AA5969DAAE95A65B24D7105E8B689B72B2E59989C8DADE9DAB989AFEE758D3AF24BED1D6D7C83FBB720FCE73C8AB84B526513936756843050430FA54FE1FD5EFF49D4CC3B8B59CA72C1BA8FA53264565C2AE727241ED5504ACC8CBE5074E9835A3641E8375ABDB5DDBBBA5BADFDB91B8AB10369F707A1A8EC7EC9710086CE02AC32160DC3E507D08EB5C7DB153A7C8A1845205386CE33C74A934AB8FB15C43756CAA1A3E7AF2DEB50D157365B4EB3F0CD95DDDA6F47738397CE7F0A3444B5D7ED0DF5CDD5CDABDBB6DD918E09C77AC4D4F5BB8D62ECC5343B6DD9836D3C73ED57AD6FC5B3B410B6D8D06164039DC7B9F7A2DA05C8EE6C3487B98A173FBD57DDB3764E05645E5E476B726255666E3E503F214F9ADD7FB464D46591D9D9F7649EF4FB694DDCACE23C67AB1154262DC324701791497917181D6A258BCAB40628F000C9007435AD6D606691B729C2E39FAD6F69BA6C71BCD1C8A19186304544A762A306CF3595B32105BE63CF5A96CE6FB3DCA48E8264539643FC42BA5D7FC170C664BEB176DA3968FD3DC572B1ABC20F9BC80783551775740D35B9EAFAFF886E753F05DC5D68B04F02DBF961655EE9DC0FA74AB51ADCDEF836CEE353BD92D350BD83C853C80493F2E47AE05723E09D6350B26BBB4B13F68964881B7B57E5598B0C9FCB26BD0F5EBFB8823BA10DB334B6D6E26572015CF4E07A8AC24ACEC6B177D4C1F05F83F54D11AFC6AC6396D278CA1843EE594E7AD66DEF8BE2D2F525D1E1B6586D54840A0E027F9356BC3FE2CB9D520BA8F5027168865564E3AF041AE3B5A96C35ABC5D6206655270D111CB115A28EBA99B6ADA03B5EDF78D2DE48CB7C8E18B11C28EF5B7AB6AB60B2DE6A36970F2470308CC6D9C17F51ED4EF0342D7D1DC493ED432031ECCFCEABEB59F736DA6585D4DE1B7DF3EF3E63CDD0061D07E554ECDD89D52296A53A6B3636B26C481CC9E63AA8FBE7A565DED9BDADD194362594648FEE28EB5A17B6CD6DA95BDC2C67EC91A647A13D2A2D46432DC5C4F2A2C7F26085E95A220CC5B98A001986E6278A963D49A0D462528080C0E4F5150D9C10CEC0B0CECE6A4796CE4BF527EF46739EDC550753D4D3E600F6233520E9C715142E1A1461D194107F0A716C579CF73B16C3B269DF85301CD05801D68011B00544BCB63152B11B6A2F330714013845029F81ED55C3963525319A972F899FEB54A590E0E2A69A40D72FCF7A8CAE4D2EA24411AB13939AB2063AD28C01DA94D016236CE7A54B08F5A40BDCD024087A52604EC001CD40EE41C66832163EB404DC4645002A2EFEA3352B288C6694958C75A8DE5DE693003CD1481B02903E7B53024118C6E2280C3A0A55C94E78A444C1A008DC126ABC8AC2AD48C01E2A195895E053432DE87205BD1131F9645209AEA6DA382289004076F0A7AD79FDE79E9A6DD49036D956262A7D0E2A6F87FACEA93685733DE2992181C6C62793EB5A416973299D56BF691DEE9ED6CD0ABABF18615C0DCF87ED749D6AC0C23CB590B0F2C9F415A4DF1210DDB09ADCB44188C8F4F5A5D427B6D5D60D420908DAEAE99E323D2B56A442B187E2FD5350D26F74D92CD5BCA660ECDD99BA107F0AEB2E626D4BC35702194412DF4612189CE08FF003CD58B0B782F619A1B8896448D77A8619C1AE4B5F7BA9FC6FA65B5BA388E008508CE07726A23AAB16D5990EA175E28D175D86D6DF7DCDB45128643CA74EE7D4536F2EF50BDD605828558028790B1C924F615AD3DFEBED713A8B544864B9DB1B30E481FC5EF5574E82DC5FCB235F25CDC44C4320EAA6AD3D2E46EEC675DE8A50EE418C75C77AAD7BA608A24F2D472BD7DEBAC6607B553B858D9769031DBDAA154EE68E08E02EAD276316CC8CBE2B716DA03029863236AE064756EF5A371620AA9400953903D68166554AAF4C938AD14CCF94E7F52B38E6B9135A8658F030ADD8E2ADD85917B7DC5396E735B915927945597EF0EB8A9EDED9514051C0A4EA0D40C49B4BDA42901948CD3EC74FDB26CD9D715B72C59238E9524508421B8CD4BA9A14A1A90416AA92487B1C55C44C608EB4C6C83C548A78AC5BB9A243F6F1C8E0D79FF0089B4C8B4EBF23A5BCDF3267B67A8AEFB39AC2F16E9ABA968AEA4ED9613BD1BF98ABA6ECC99ABA39CD1649B4AD406A56B92F676F2381F5181FCEBB1F03F89AF3554BC1AABEF78177A4807507820FB560F8100FF008486D6D2641379D1BC6C87A38DBCD775ADE8F6767A64BA7E956C96CD70A54327049ED93E95ACED73285EDA1873CB646DAE2EACAD5238A5C891A21C3639E7D3BD737A2699A66BF7255647B6168FE67903A38AEABC29E12D4B4AD2EFA1D4954477585080E7A7F1565DB7858787AFAE2F56E4C8A2260AA17900FAD35A09DCA3E1B96EA0F1B5CAC7685E14DDB901C0C76356EF74AB2D4EFEF2785D45DC836940DFEAF3DCFBD5AD0F5C81EF6E74DB689E396580BC5237077E338AC0D0E1D42C61D4B50955A09083B4BF5639F4A684C982DB053A60944AD1811AF3919F5ACEF13DAA59A46899F9C7CE4F7355B46D2AFA6D5E1B90F85C9777EA01EB8AD7F156E7851668C028721B3C37D286ED2490D2F75B39682786DE3C31C17E300734DFEC969246D9201BFA67D6ACC5610961330DC7A81D6A8CDA8CCB72CA87186C0ADAC66B73D5EDC14B7863CF291A8FD2A51D2A0833F65889EA5067F2A7678AF3DEE76126FA4DD51A9F7E29770ED45807B1E3151A8CB669A5CF4A7230EB401280179A7EF1ED55A4971C0A6F98D4D2034C8C4F213EB4A5891E9514F21FB538C719A93A28F5349A0444662ADD78A9D25DC0554954EEC815661FF5583D68604A64EC2A19037DEE691721F26A6665231DE90C8A2DDBF9E2A7326DEF50918E477A6EEDD9A403A498B0A6C72FA9A69C28E453181C64500591203DE9EAC38A86242C3FAD4FB303AD004CAE314C91CE302A1DE43601E28660050028CB7269E5902E2A1DD9185A110F7A6226F2D5E3653CAB0C11EB5D2E9B656B63A62476F0AAC6CA0E3B7E35CB99368C2D6F27997DE1E16D6D3AC771B319F4E7BD5C08994AEFC15A26A12FDA668A48CB0E91B616B95F11C17B66D05BD88FF475701881CA806BD034DD3EE2C6CE1B67B9694E09DC78EB5CAF8A088AF0C4B90FB94641FBC0D6C8CF42AEA5ADDCE8966B75005705D5640C3AAD7508F632D9C334613CC316F1C82CAA466B9D8F4B83592B6172CCB1CBFC4BD411C8AA575A2EA567E345684486C45B840DFC380318ACA36668F7087C576BAAEA2DA68122B26E547EC48ACAF0FD87F67DDDC0725E5964662DD80F4FAD6EE97E0EB7D12E65BE595AE257525548C05CD65595E5CB6B66D5E11E5A96DD28E9BBD056BA59D88D6EAE6C952133507945CF3560B1236D382E3A0CD72DCDCAC20DA4FE94EF2C28C9EB569403D692440C703A53B85883CB523DA9000838C539C6DC5279648CD17018C724E39A6862BD6A558E99328518C53010382735206AACA3BD4A9D79E68608796C726A9DF079AD678C7DE68D82FE556659369DA69AAA0B6E3D075A2F6158E4BE1EC530F1769C672774733819EFF2915AF77AEEA767E3B852F0388D6721A16E9B4F19159F6B791E8BE30B66738314E1C0F553FF00EBAEFADB5CF0CF887588564543790922212AF2C7D8F7AE97DCE7443A9F8E34CB6BE16FE638646C13DAB9865D474DD427D5AEEF8CFA6BEE755CE4F3D2A4F16F826F8EA725FE9D0B4F0CA7E6451F321FA7A54B73E1DD427F04C1A6BBF9572A0B1563D7D01A4924377D4769777A6CF0A6B71DB0373B5937004E3F0AC6D7B50679487624B8F99474AA9F6D9BC336367A6019B99A50D29EC149C1C536CDE1BED6E5562CE8AEC403E83A0FCEAAD6D457BE86F68B095D3E360BB19B93919E2B33C5E812DA27772486E9DBF2AE8A365400602FB0ED58DE29804B62AF8070DC9F6AC212BCEE6D25689C28D55B3B238F81D33576C6D2DEE668E778F0CC4641F5CD361B08626670BCD44D7B226A10431A9FBEA081F5AEC7B1CAAC7A731DAB8EC062A1DD91D69F292471DC5351091CD709D823360E29CA460934D65C1A5514009253549A57E0D00F1E945842633527962A319DD53E0D3197E740B7121C739A66EDC714EB862F70F8E80D323520D4808EDB4F34E4605A993290D93D2A304AB022802F1002E4F355F782F4E32EE8FAF4AAE8DF3E690161896181D29CAA02FBD3632075FCA93CCDD263A503126E281CA714B2F22A246C363A5202C44702A472587CA7AD547723A1A449C8FBD4EC2B96C2E054520C77CD46D7191C1A8848CC7934580B516075A92470178A815F2BD6A390B2E4E6801FE6FE555157594F12D9DE69C2478385902FDD033CE7F0A371DDD6B7FC39A8C3626E45C36D8767985CF41570766292D0D5F11EBEBA34100F2BCD67E335E6BAEDF5FDDF8AEC8BC6C91BB024649FCEBD5AE62B3D534A8E56449E3FBCA719AE27554DD7A8CAA308F8C7A56E6112C69F218EFADD864E241C7AD5DB4D5EEAE2D2F1B56845979770523DDC6E5AC88A7F29C498FB8777E5CD5CF1D5ADE6B7E1F8A4B45DD9219A3CF3CD611B6C6F2EE4BE28D6E0D0F4D6B825A40EBB6209D18FD6B96F0EDDB5DE9EB706355334CC4B13CF1D80AB769E1E92F7C2EB06AA644DBCA275651ED59FA3ABC1796D6C1592DE0898827A124D6A92517632DDAB9BA0B938AB018A2735189141A909590006B9CDC5561B734824241E29B9E703A54AA107140C61009CB52AB29046295943743C5342AAF7A40294039278A827C1E94E7939C66A07932719A6205C0A95003935031F978152C271D7F3A0431E3DD28152CAAA88117B7534A0756F5E0546E79C1F5A37199775E1B875CF10E9AECC530C5642BDD4722BA45F87365FF09045A95BDD3431A3890C1B72723D0FA565473C905CAC9192AC8720D75D63A83DDB24CA77EC8DB7281CE71915BC64ED6319456E56F11EA5A96917305C5BDA7DA2CDDB6CEA99DEB9E847B573FE33BAD5174BDFA4A132B919DA3E60A7DAABD97C42BB9F5BFB2DDC20DBCB2145206190F6AC0F1478D6FA2D664B6B360B1C4DB4E57AFAD528BB89BD0A7A85BB4E6D2FAE9F75CAAEC789BB11EB4EF0EC512EA592A4B1CD50BED50BDEADBBA7CD2FEF0B7D454D6774DA7CF0CDC7CAC338EE3DEB56B468CD3D6E76124789001599E232E34E09D8B0C9ADB01655595070DCD50D7E3DFA35CF1C84C8FAD71C5DA48E996B13CEA7D57CB9FCB550C8BDC5686936D6F73A8DADEB0272E3E5F7A80E910328E369C64E2A3B6BCFB0EA7690AFFAB8E51BBDF9AEE7B1C8B73D2CF2D8229CCBB578EF502B9F32AC9E40AE03B0AC47E74063DEA42B9A8CA9040A68047E4640A6648353851B6A1908DC075A602A9391EF53EE3512292054FE51A00BCFF2CF2679E6AAC92ED734B7D7405DB22F0DBB0055267D92344CD928C4134F949B96CCE4F2D4C69411C556966F976A8CD337E46052B0AE5B866DF95279A5313AE4C646E3D3355506C3B8F1F5AB8932B28E475A1A1A64864C1DB8A215CC99E69400C4538E23E952325902FAD529A455231449739279E2B3E7BC40C0672685106CB3E764F2682E59B0BDEA88919DB2338AB506E53BBD7B569626E4E54AE33DA98256DD814E9252C40C54F045104F326CECEC3FBC6B365828611993071D8FAD31A724728F8FEF638A917CC9C832B770005E028F41524F18CA90781C6053405640ADF5AB3630C5A8DF5C69523855B8B46048EDCF07F3A8176877518254E322A2B179ACB5D4B9811A490B6D0BD778E334D1327A1AF6F35CF83FC39069FA87EF1E498E086E02F6AAB25CC2F04E8E76CE6E03286EA462BB0D5F4ED3F5B88DADCB0324643ED56F993FC2B87D434C686F4DDA02D189FCA6DDCED00715BEE8C56E4CAAA71BBA1EB5D97910AC5941952A09C76E2B8D8B03E66E47A7A9A8F563AEDB43632D83CD2ACF31762833B40E315CF146F266E4DAA585FDEDC59C1711F9B1290C9939AE6349B896F6D668E5B758D2D1CC6AC3F8CE7AD6AFF60C3A6EB377AE79CC0CB1167887F09C73CD66E97389F475991195657246E3D72735B69CAEC67F695C9C617A9CD588C861924557555625378DC064AD30B053B54D739B9659B9C0A68665EA7AD31582F6A6BC85FA5004924BB17767B7150ACAEFD4D3CC794E4D33684EF40870049E681174C8CD2EE555CD33CFC9EE69812850A3A73498DC703BD2AF2B934AA7827D781480459803B474C71485807C91907B5392DCB3F03F2AB8968AA37BF6A2E0C852D9245C9FCAA392E2E34BBDB5BFB4627C89079D101FEB223C37E23AD4B34A73B23181EB42A15C31EDCD35269DC4D26AC69FFC21DA1CDA88D6614625DFCD5546FDD9F7C572FE2AF0BE9F36A6752DAC8E486745C0538AEB34EBEB2D2743559E7090A3B0CB9FBB93902B9ED7751B5BED3E5B8B2BBF3540209419E95BA6DBB98BD158E12EAD60935E7B99DD846A8701464F4E2A33BB62EFC1CA8FC699A637F6E5EC714B98C33EDCAFA54B3A8B597C876E13E507D715BF5323B3D06EE6BCD391A6B7316DF95493C381DC54FA94664B394019F94F158BE14B972D35B99F200DCA8DFD2BA465F535C725CB33AA3AC4F3D91840C7CCF971D41A5D33438F53617B1BAB01F3E01E4107BD43E24B4965D51E08F3F78B1F7A74D6F77A169C8137466E231B883CE0F6AEDBDD23936676D8CAAB01D4034FDD9181587E17D41EF34AF2E5626585B69CF523B56D0207D6B8A4ACDA3AE2EEAE4CAA314C913737142313CD05F71E2A46348217039A8027CF93539CE3A7148AA4F38A06390E31536F3512900E054DB680294704B2EAF9C642C9BB9F41CD462DE467F30820B1DC73EF5A370592F02C6482EE7247A639A91A278C8326133D17B9FC3D2ADC999A45216DC0CF5C53447E5B12467DEAE4831C8EB55F6EF383C0142020652EDC9A51161F2ADC77A1C7273903A66A48A12CC3E6C01DA988B28C4228C7D4D4970C3C9057193C0A8642E19500E7D29AA08910B1CA82011ED51B97D0CF72E09EE6A0FB2B3CBB88E95AC12397E6421B9C714A22038C7E155CC4D8A4B188D40EF52A6172506E3DF1534B179673C6F3D07F747F8D3EDA28D83173B517A81D58FA0FF1A4D8D223895844679106D07001E84D356669A5DC7A76C74FC29D7923390A400A06001D00F4A8171132BF63C1A5D07D4B85CF017A8A00660416C0F5AADE6E1B39E94C6B97DDB472CDD0761EF4582E26FF00B34B32BB80A0EEDC4F7EF496B3471788ADB51777296A0B00ADC37E15626B657B759597CCF307CCC573F30E2A9E99008F555694E2024292E30073CFE1568991D8B45A545E25FEDB5BFF002E4BA8C23216CA9CFAFA554F114C61778609374724818B0E83FC6B6E1FB149613DB9B588C56EEC8898C838E86BCE7C40974B791DA42E5C9F9CAE71B39E84F7157177336AC6C33852AAA3712428507D6BA0D1EF6770F03C5B2DE08F87230189F435CE2E58DBA060BB7059739278E9ED5B37906A579A0486CF6B4910C4117F78F727E9DAB24B535E845E20BE86DB41BCBB489E7C2105954ED3DBAFA573BA22492F8621292F9403FD703D0574DAB6AB1E9BE1BB1B5D671F68B94F2DD00CE4F4358F6DA4B59E89C3283E69DAA0F55ED5AC7E168CDFC4848D52342A8092C7939C963F5A640BBE53F36003CB7F41503C85731EEFF788FE429AF2951B538CFA565636B97A59533B579350331CE4715073E5E7351B33FDD069D8572E89CB1DA289236C039EBE94CB68BBE39AB7B0938278A9634450C45873CE2ACA42A73C74A7C71EC153A440AE6A5B1951909CE3A0A589324123F0356484499107F16735349147D47D734AE3162511AEE239F5A566F3060F4AAE252EFB33C0A9246F2C0148042AA9D853586E5A373483D29E02A0E69814AF34B8B57B1974F99CC69311871FC2C3A1AC7B0F025E686D72D7176B2C3226008F383EE4574523294217B83D3B54FAEEBB6DA6D9E9D65A8AB4735EC432F8CA83EF5B5393B18D448F304823F0DEA703A2EFDF23804F63DBF9D4DAFE9724FE1D17C80F9D1CA44807E86B43C51A7DB4D71F6C8670E9032A90A73B588EF59DAB5C5DE9D6F114B86922BA1F3C6474F4AE8BEA636D0CED0EF25B3686E812190E0E7B8EF5E8C2612C6B229F95C64579CBA8DBE8185751E16BF692D0D8CAE5CC3FEAD8F5DBEFF4ACEB474B9A529741DABD92A5EDB5F0191BC2C9EE2B675D363A9ADB593226F6607E8B4E92D92E6068DFEEB0FCAB2AFB4A96E4ACF14844A8B8C93CEE03FAD2A52BE815236625BD843A6C225870220E632C7A9E78AB5BC115CA7887549E5B586D9418A34FBC01EA6B53C357735F69A7CFF99A26DBBFD476CD1523757084ADA1B7B82A54424039A6BB8C6335113938AC5235B9604DBB814E572A2A28A03F7B352961F9500387273536FF00A552694E401C0A7EF6F5A761DCD2954ADF17E922E78F4CF7F7A9265F306F39663DF3D6A3BE3B6F26047F1F5EF914915C71B64E9D9BD6864A62001B04B71DEA30815896276F7C0CD3A3766DE8F8DC1F031DF3D0D472CE0482307E5519FA9A5A8F41A51E46DFE5970A085507BF6FC6A481845321111938DD8CE0539266895CEDC853923F0E323F3A8AF6468278AE147EE54E1F1C8048EBFCA9EA22662132CE0177E49AAF3799E5318946E0095F73E9523CC938C81C7D69D97124688AA5194E7D411CD2B587B8B03AB46AC100CAE4014292ADE698CED56C6739EB4F01622F146C0A9F98363AFAE3F1A5B8665B778C0DA2301F9EE690215E0DE8D231E4FE66AAAB47092642A09E82A492EF7C1138C64A8CE055695E063BDD54B766228482E45732E5F18A6167906C0B43DBDC3A79A15922CE379E33F4A43388A3F313843D58F5AD12E84B137A93C8E7038F7F4A7C6815B2482C7AD44EBFBB5921287BB65BE6E7D07A53AD5C25CA24F1B49B94B00A7973FD29D985CBD0CAEA76348C17A1E7001F5A9741B48DE5DF2C6AD1B39606E0E79CFA7F21D28135A65E1F3028C7CC26F94863D7F0A92E6748B4F125B22F9F13EF59073BB8ED4ACEE2B9B971A94561F6A54E598EFCB2E17A0E79EBF8571FFDA105FDE3DFA90D13100B9E369F5C7F5AA3AADD5EEBCAD7259C1DE06C63F28C7FF5EAC4124BF60649A24456F9311F39ABE54912A4DB3434E6011E6380653903BE2B4567D4E0D1A793468C5C5D34C328DD1463AFE358113BA03F393D36FF00BBDABA1D2F571A3AA7DB7CAB7B59542A3BF56973CE4F603350D1A5C5D72D6DEFEC2D25D65512E908C82D858DBD3DCFB5645CEA16B6D722DA5721B7719EE4F4AD5D534CD36FAD592F3533772C6ED3C3B1B8FA1EC6B9996F122D45E0BA61BA4C147DBDF1D2AE3748896ACD130A30796460B1A0C903F9522C7118C1CE49E699E7B6C5561B70385CF35483181FCA07F76DCC673F74FF0077FC2A2C5DEC5B923E719E3B53A281DA4E450840C6482455F45C47B80EB498D6A224586C53E465040EF558DC1126DEE69F925F27F1A96868B68E460B0E054CD2A94C86FA554672540A8D0B34840E8054D864924DFBCC819278AB6013164F5354E2FDE49C0C81DEAD4CFB63EBD3D2900A8AA80B534C9B8F3D45461BE405A9AD3A8E71458091E5DA3815134E48EB41955D7007268822DBF3BF6ED40C50C767231C574BAF69FA76A9A2DB0BE8E370143445FA86C76AE62598EE38E456BEAFA7E9FA9F85609B508E567B787723444865FA015B5232A8B638AF13785068FA7BDF4174D22B48048A4631DC7F3AA5A1DDD9CDAA587DB2D662A8863632A8F2DC13D79F4E39AED5EE1750F09425B6CD6EF10762FD5C0E3F335CFE878BFD1DADA36123A5C7948A472AA4F1F5AD39B433B6A729E30B49749D7DD235FDD6ECF038C1E6A97F6A4BA55C453DB8CB039C7AFB1AEAFE25DDDB586BF04063DFFE8EA188F6EF5C8128D2038C86E456CB5465B33D2F4BD42DF53D2A3BD8BE40E30C87AA9EE2A42730CA0753C8FCAB1BC316CD0695BD94FEF5F70CF715B255C9DC3031DAB917BB2D0E9B7344C31E1737D2E2639849C96F435AF61A6C5A0E8F21678CA282DCF191568DDF936A70BC839C0AE6FC67ABF976AF6B193893B7A574277307A195A66BD25DEAC6DE50A23918F97ED5BF7B243A76D3752797BBEE9C75AE4FC2DA74979AAA15C601C82C719ABFE399A437915B2A93E5AE58839A1C131A9B46D35FAA4225DD98C8CE40CD569B5DB3822572CCFBC65428E58565DADC249A4E5CE760F722B9D5BE9609088CF53C9C6292A687ED19D958EAD1DF3ED29E536780C7935A7893DAB94D1EE95EE919C82C7B8E6BACF307BD44A3665295D134B72C6E245DE4FCEC0E79EFC5482602227866E9B47356AFF4A85E57F2372F3F31F734C8ECE3894A127D06D38E29F20B9D19CD249110C391CAE0FF004A5B7996E26F2E121589C6D3D56B41AC6D8A6155C28CE093934E92CEDD172D000C460B1E1B1D734F91F41F322B5D7FA2C8CF11DA3706E4F0E70304FE59A81E6DDC97639240FAFAD68325BB95761BF8C0DDC92054A9044C705554039008E953ECD873A39E59A4B162C4620DD80BE9CF515A3F6832469146AAE1B059F3C63AE335AD77A72982213471BAB293182436D1EE074AA012313158CC48233F2AC5D0123BFBD0E9B0E6192333CC8AA0B6D2381DFDA9D7B2ACB232B03E59C93EFDB3492DBDDC476C32AB903055C72A48EB91FE14C68B64331900462413B06463AFF4A4E9D95C6A45416FE5BC72A3395650AE57D7B1156E3DE2F0DB130C6C8011239FCFAD58B695A78C64AAA2AEE3818A64A226BE85C00EAAA47CDCF5EF54A0AC2E620D511D21493719406C12C7EF0F507B0A874F5B2F39D66DEEA70C8846133F8F5AB5AB2C935A1DA708A4670319AA376A0416D2DBC8A1DC15DA39C0C75A5A263D59A82DE13345346AAAF11CE1865587A30EE2B1AFEDF548EF0DE93E64A1F20A0DAB8EE00ED5B115BDD06880910F037B77C55A9010B903381CF1F7BE9FFD7ABE842DCE66696E9D58F93E6CC643BA32A373670723D455BD4351B5B7804F7513985390919C9FC874E7D6AE1096F04F012646BC2BB1D53E6419CF1E9591A8E9135E6A1712587EE664604824B06C8F5F5FF1A98AB952D0C7B7D7AC657746B968A363BB023F9947A1209CFE55135F5E3663B7D4ADE68B0CEA236DAE0E38C822B5A5D0671166F34886455193E480AE0FA8DBD68B1D1B4E0E162B3950A4A373C9D58118C0F4ABD1233D44B27D6AEECE3B92A91A6E557320054E39241F7ADCD6B50B4D62DD20BFB762F2315889C2C7093C0639EA7F95675EDC8496DAD20BBC67263810606338191E9D6A1D4035EDDD9C17480C45F322C671D3B7E27152E37D4BBD8B30D9DAAE98DA519CBAA9DDE606E491DB2471F8566FF633EACEF24577E4A07030C09E475E6AE9D56D1D3EC96A58146DA4118DB8CD5AB0D4607B33E5C00B9E42270587AD524EC26D5C7AE9532911ADCAC81001BA41F337BE4523E952B09037CCBC7DDE49FC3DAB075AF15CCD70F0E9E11178CCC392D59536BDAA4F1323DC91BC60941B49F6CFA51EC85CE7596B345F6F9ADAE2E621242AA15777FAC24F6F7F6ADD85D5D8425E30F9DA14B8C93E95E484B9C1272C0E735A3A7E937DA895F295979CF98C481D7B1A6E927D4155677DB51A477046158A93E847515304057792029E84F7AA169A1416B6881F373708397773CB67D338AB50C0ED190E37267186181F4C562E9BEE6AA64AE48181D4D3D144568D295FBC7007AD323996473195DADD718A999259F10A2FCA7A2AD4BA4FA0F9D082E2358F72F71E94EB55375BCF61FA51142BB4A1651D80CD5A816221BCB91778FBD8FF000ACDA68B4D32BCA02C646381C0AA130658F785CFCC179F738AD2DF186C3E4D66EBB73E4698D2C45576CB1FDEE9F785086F42E18445D3B75A1F2E9C1C5011A47C6EF7A19A08A4D8F2E5F19DAB523214819DC22839E95B83C411E9D62D1EA16D2594118F2A3965C7EF0E3AFB0AAD64B2BEEB8B789098864798700B7604D519B549A4B9FEC9F10406E0DE2E0BC70FEED7D81EBF8D6D4D194DF417CBB08F40736D771BC06362815F232724FD2B37C2BA15E6A1A333DACED663CD2CF201F3371D17E94DD6DECECE44B0D3ADD63408576AF43EBCD6B7853577B582D74F8E0731FDA0ADC480FCAA4F451FD6AF6237D4C2F17697793787ECAEB5368A7B8818C5E6AAE0BAE78DDEF5C5C56CD2CB1A2292EC70057ABF8DEE2D61D2E4D3E520798DFBB39FBA7AF35C278734FF003EF9E6979FB39C28CF56F5AD14AD1D4871BC8EA6DA3F2AD6289801B100C0A7312338CE29448E87A034D798BBEDDB5C7BEA74EC31A7655CFE958FAC68EBABC0D83B641CA67F956CB5B971BBA0F7A8D6DE493804802AE327125C5332B4648F46B5324B1825465863A7BD71BAFEA7FDA1AA35C2060B9C03E95E893C51AF0793D0D663E8DA54923B9800120F9D0743EFEC6B7554C5D3399B6BF10D815C80C47A63358ED0DC5CDC1F2A36249FE15E2BBA3A6DA8B7FB3BC2248BF877751F4A9ED6D23870A89D3A67A8A6EA82A660E93A6DE448AF3C5B31D3815B9FBDF5FD2AE346C08C8E29F8FF0067F4ACDCDB2D412343506796E648D9CBC4B212BE59C06E9F7BE9CD3C300A1A45C13DB351DD7093B8E0862011D851E5A10AE46580EB5BA312492508305405C727355E39629676023CA2000EF24727D29241B9F0DC8CD1F720240192EC7A77CD0344CD16DCE246FC00C53D18AC6BBB939E7B5471FCC109E495C9A589419704647BD0006E1D65DD90573C83903F4AAF1303279D9D8AEC5B6AFD7BD580A3E7E075C543028F2D38E840FD6931A11D9E596593CC6059BE560013C1FF0022A0941B6B3DAD23B85196673CEE27B56ACFCDC95ECB9007A553D6494B072BC10A1B8F5C8A97D8A8EE25A064B740D18727EF1CE00FA8A2647B5B69774EA1594B061C15F41CF3535B002D67038CB127F2AA33286B00A7905B9CF7E9537D2E35B94EE3509329048B239D982E4601E3AFA75AAC249247FB3F9726E570A5C8CEE3EA2AB5CB31B911963B51CED19E0735A86474960DAC4665A928DBB5DED17CECD96FBC586D0B51CB701E3922B79407007CDCE5B9E82AC5CA8DA8B8E36838F7AA3A6C6B25D5D338DC617FDDE7F87239AB93B2222847DBE52CAAD244D12168F60FE207BE7B558B5BF5921579E4C37F1285E09A98A8FB5C098F95E33B97B1ACDD3FE7BDB856E42EE503B000544772D8B6935E5C4F2B971E52B1F2B38FD4D4B2C2AC50CD2EE7553920633EF4FB289134988A285CAE4E3BD59BB8905947205C3210A0FA026B5B19DF530A5F0ADB8533A4D32396564914E5979E83FCF414EBCB60648E5E45C40C5899138998743C7E7C5748F0456D042615DA5F058E7249FC6AADEC31F9E89B015685D883C8DC0120FD73DE860737A768B6FAAEA3F6E258CA923199211B2327D0FB53756D0F4D53E6B858981C178C9C7E9E956EC608A488965E5D016C12371DC7AD692A25C493C32A2B46908DA31D320E69A7D44D7428D9F8574757564884BB46482DB973F4AA2DE12B0FB4BB992411B1CAC6981B47F747AD741A75A41069D12451EC5DA3A13CD4BF62B773B9A204A4B85CF614F99872942C6C2C2D90AC3611A1CED5665DC5BF1A73232BA95851631D0678FCA8B9768B505810E22DDB76F518C6714F9C95BC481788C6E50BE800E052BDC63C90CAC1573EB91D29D14933611153F33D2A4BA511A00A300AE4FB9C0AA6DF282178010F038A00B5285560D22EDDDC865A748F22C4648CEF6EA011546EC05B600700B0FE9576100DDC6879503A1FA53115D2F7CDC24D624264E651FC3EC6A687ECEE4BC337EF072093D053AE8058DC818C8E7F3A48006B76240C920671DA93498EE4B1DD41336C2AAADF5E2B0F546CDADB5A4E0490DCDCAABE4F2801CE3DC558B9458EE54A0C6EC06F7AB1A6D9DBDDFDA7ED112CBE48DF1EEFE13EA2B19534B545A9B7A32F174862E76A2A8E5DBD2B22DE585F5B771379C9220D98E466ACC31A5DE9B71E7AF9987DBCFA62B9AB376B50EB0B1401D94007A0A9505629CCF457BF7D3F45296F62F71383931AB0C9F73E82A859DDDC25A5D6B133CC619220A96F2807C97F63E95909753B0B72656CBC24B7B9A9CDC4D2E8D76B248CC3CF55C1F4C0AB44330E7D496F268E458C2C9CA36EE4139E4915D3F872282D674BC9640F6FB5E5B6CE55A5DA3990A8E3BF7AE53548D20B680C4A10B49B491E87835716E268A5D3D12570A8E22519E8849CAFD2A6F7653D8B1AD39D6F5C176E53C80BB95377CC7D4E29F1C2912178536091B7703155A751142CD18DA5E40A48F4DDD2B5955718C703A5151D90423A8C48DFE501B2CD52C88B12E7033DEA4B651BDB8A8E7E5C83D3358F535200EF3673F2A8E82A2CCD92412231FAD58451BF18E296E00385EDE94D099484E276F2821F7344B6830366463A8AD286089412A8053CA2F3C51CD60B192B6ECA774869F2010C7B80E4D5875067C11C7A524EAA480450B561B15222D2C83238CD5FFB32FA8A66D089F28028DCDEA68E603FFFD9

exec dbo.cs_Posts_UpdatePostsInCategories @SectionID = @SectionID, @PostID = @PicPostID, @CategoryList = N'<Categories><Category>Wildlife</Category></Categories>', @SettingsID = @SettingsID
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_system_SampleGallery] to public
go
