if object_id( 'dbo.cs_system_GenerateWeblogYearMonthDayList', N'P' ) IS NOT NULL
	drop procedure dbo.cs_system_GenerateWeblogYearMonthDayList
go

create procedure dbo.cs_system_GenerateWeblogYearMonthDayList
as
begin

--	this is the start of main step 1.  We would need to store the tblSuffix to know where the process is
--	so subsequent steps can continue on from this procedure
	declare
		@tblSuffix nvarchar(5)
		, @tblSuffixOld nvarchar(5)
		, @sql nvarchar(4000)

	/*	if table 1 is full, operate on table 2 and vice-versa */
	set @tblSuffix = case when exists (select 1 from dbo.cs_weblog_PostByYearMonth_tbl01)
		then N'tbl02' else N'tbl01' end
	
	/*	if tbl01 is the target table, the old table is tbl02 and vice-versa */
	set @tblSuffixOld = case @tblSuffix when N'tbl01' then N'tbl02' else N'tbl01' end

	print 'Using ['+@tblSuffix+'] for this data run.'

	print 'Truncate table: ' + convert(char(19), getdate(), 120)

	set @sql = N'truncate table dbo.cs_weblog_PostByYearMonth_' + @tblSuffix
	exec sp_executesql @sql

	print 'Removing PK from table: ' + convert(char(19), getdate(), 120)

	set @sql = case when exists (
		select 1 from INFORMATION_SCHEMA.TABLE_CONSTRAINTS c
		where
			c.CONSTRAINT_NAME = N'PK_cs_weblog_PostByYearMonth_' + @tblSuffix
			and c.TABLE_SCHEMA = N'dbo'
			and c.TABLE_NAME = N'cs_weblog_PostByYearMonth_' + @tblSuffix
			and c.CONSTRAINT_TYPE = N'PRIMARY KEY'
		)
		then N'alter table dbo.cs_weblog_PostByYearMonth_' + @tblSuffix + N' drop constraint PK_cs_weblog_PostByYearMonth_' + @tblSuffix
		else null end

	if @sql IS NOT NULL
		exec sp_executesql @sql

	print 'Insert base day data: ' + convert(char(19), getdate(), 120)
	
--		this could *possibly* reduce locks by only calculating the posts that have
--		been 'added' today ( getdate() ) and then filling in the previous data from the 'other'
--		table.  But, that doesn't consider if someone changes a PostDate from a previous day
--		on extremely high volume sites, I think it would be beneficial to only calculate the
--		previous day's numbers either once a day, or even calculate that once a week.
	set @sql = N'
	insert into dbo.cs_weblog_PostByYearMonth_' + @tblSuffix + N' ([SectionID], [Year], [Month], [Day], [PostCount])
	Select
		p.SectionID
		, Year( coalesce(p.UserTime, p.PostDate) )
		, Month( coalesce(p.UserTime, p.PostDate) )
		, Day( coalesce(p.UserTime, p.PostDate) )
		, count(*)
	From
		cs_Posts p (nolock)
	where
		p.IsApproved = 1
		and p.ApplicationPostType = 1
		and p.PostDate <= getdate()
	group by
		p.SectionID
		, Year( coalesce(p.UserTime, p.PostDate) )
		, Month( coalesce(p.UserTime, p.PostDate) )
		, Day( coalesce(p.UserTime, p.PostDate) )'

	exec sp_executesql @sql

	if @@ERROR <> 0
	begin
		print 'Error occurred while inserting base data.  Truncating table: ' + convert(char(19), getdate(), 120)

		set @sql = N'truncate table dbo.cs_weblog_PostByYearMonth_' + @tblSuffix
		exec sp_executesql @sql
		return
	end

	print 'Insert base month data: ' + convert(char(19), getdate(), 120)

--		we could possibly add the constraint here and do this in two steps
--		this would be if we had extended times for this particular step
--		since there is no other process hitting this table at this time,
--		we shouldn't have issues with locking
	set @sql = N'insert into dbo.cs_weblog_PostByYearMonth_' + @tblSuffix + N' ([SectionID], [Year], [Month], [Day], [PostCount])
	Select
		p.SectionID, p.[Year], p.[Month], 255 as [Day], sum( p.[PostCount] ) as [PostCount]
	From
		cs_weblog_PostByYearMonth_' + @tblSuffix + N' p
	group by
		p.SectionID, p.[Year], p.[Month]'

	exec sp_executesql @sql

	print 'Add constraint: ' + convert(char(19), getdate(), 120)

	set @sql = N'ALTER TABLE [dbo].[cs_weblog_PostByYearMonth_' + @tblSuffix + N']
		ADD CONSTRAINT [PK_cs_weblog_PostByYearMonth_' + @tblSuffix + N'] PRIMARY KEY CLUSTERED
	(
		[SectionID] ASC,
		[Year] DESC,
		[Month] DESC,
		[Day] DESC
	)
	WITH FILLFACTOR = 100 ON [PRIMARY]'

	exec sp_executesql @sql

	print 'Compute stats on new table: ' + convert(char(19), getdate(), 120)

	set @sql = N'dbcc dbreindex(''[dbo].[cs_weblog_PostByYearMonth_' + @tblSuffix + N']'')'

--		this is the start of main step 2.  We would need to store the tblSuffix to know where the process is
--		if this was to be split from the main stored procedure
	exec sp_executesql @sql

	print 'Alter view: ' + convert(char(19), getdate(), 120)

	/*	if the view doesn't exist, make it create instead of alter */
	set @sql = case when object_id(N'[dbo].[cs_vw_weblog_PostByYearMonth]', N'V') IS NOT NULL then N'alter' else 'create' end
		+ N' view dbo.cs_vw_weblog_PostByYearMonth as select * from cs_weblog_PostByYearMonth_' + @tblSuffix

	exec sp_executesql @sql

	if @@ERROR <> 0
	begin
		print 'Error occurred altering view.  Truncating table: ' + convert(char(19), getdate(), 120)

		set @sql = N'truncate table dbo.cs_weblog_PostByYearMonth_' + @tblSuffix
		exec sp_executesql @sql
		return
	end

--		this is the start of main step 3.  We would need to store the tblSuffix to know where the process is
--		if this was to be split from the main stored procedure
	print 'Clear old table: ' + convert(char(19), getdate(), 120)

	set @sql = N'truncate table cs_weblog_PostByYearMonth_' + @tblSuffixOld

	exec sp_executesql @sql

	print 'Compute stats on old table: ' + convert(char(19), getdate(), 120)

	set @sql = N'dbcc dbreindex(''[dbo].[cs_weblog_PostByYearMonth_' + @tblSuffixOld + N']'')'

	exec sp_executesql @sql

end
go

-- now to attempt to populate the table initially
if object_id(N'dbo.cs_vw_weblog_PostByYearMonth') IS NOT NULL
	exec [dbo].[cs_system_GenerateWeblogYearMonthDayList]

go

grant execute on [dbo].[cs_system_GenerateWeblogYearMonthDayList] to [public]
go
