
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_system_CreateEvolutionNewsBlog]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_system_CreateEvolutionNewsBlog]
GO

Create Proc [dbo].cs_system_CreateEvolutionNewsBlog
(
	@SettingsID int,
	@Username nvarchar(256)
)
as

-- Get the user to make as the owner of the blog
Declare @UserID int
Select @UserID = UserID FROM cs_vw_Users_FullUser where UserName = @Username and SettingsID = @SettingsID

-- 'News' Blog Group
declare @GroupID int
exec dbo.cs_Group_CreateUpdateDelete @GroupID = @GroupID output, @ParentGroupID = 0, @Name = N'News', @Action = 0, @ApplicationType = 1, @SettingsID = @SettingsID

-- 'News' Blog
declare @SectionID int
exec dbo.cs_Section_CreateUpdateDelete @SectionID = @SectionID output, @Name = N'News', @Description = N'', @ParentID = 0, @GroupID = @GroupID, @IsModerated = 0, @DisplayPostsOlderThan = 7, @IsActive = 1, @EnablePostStatistics = 1, @EnableAnonymousPosting = 0, @SortOrder = 0, @ApplicationType = 1, @ApplicationKey = N'news', @PropertyNames = N'SectionOwners:S:0:5:', @PropertyValues = N'admin', @SettingsID = @SettingsID, @UserID = @UserID, @IsPublic = 1

GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_system_CreateEvolutionNewsBlog] to public
go
