SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_system_CalculatePagingInformation]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_system_CalculatePagingInformation]
GO

CREATE PROCEDURE [dbo].[cs_system_CalculatePagingInformation]
(
	@pageIndex int
	, @pageSize int
	, @rowsToReturn int = null output
	, @pageLowerBound int = null output
	, @pageUpperBound int = null output
)
AS
BEGIN

	/* This will need some work - only going to handle the basic scenarios */

	declare @minValue int, @maxValue int, @maxPageIndex int
	set @minValue = cast(0x0 as int)
	set @maxValue = cast(0x7fffffff as int)
	set @maxPageIndex = @maxValue / @pageSize

	if @pageSize = @maxValue
	begin
		select
			@rowsToReturn = @maxValue
			, @pageLowerBound = 0
			, @pageUpperBound = @maxValue
		return 0
	end

	select
		@rowsToReturn = @pageSize * (@pageIndex + 1)
		, @pageLowerBound = @pageSize * @pageIndex
		, @pageUpperBound = @pageLowerBound + @pageSize + 1

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_system_CalculatePagingInformation] TO PUBLIC
GO
