SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_split_varchar]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_split_varchar]
GO

CREATE PROCEDURE [dbo].[cs_split_varchar]
    @str varchar(8000)
AS  
	CREATE TABLE #SplitItems
	(
		[Item] nvarchar(500) collate database_default NOT NULL
	)

    declare @frommarker tinyint, @tomarker tinyint, @strlen tinyint, @item varchar(500)

    select @frommarker=1, @tomarker=1
    
    while (@tomarker > 0)
    begin 
        set @tomarker = CHARINDEX (',', @str, @frommarker)
    
        if @tomarker > 0 
            set @strlen = @tomarker - @frommarker
        else
            set @strlen = LEN(@str) - @frommarker + 1

        set @item = ltrim(rtrim(SUBSTRING (@str, @frommarker, @strlen)))
        
		if not exists (select null from #SplitItems where Item = @item)
			insert into #SplitItems values(@item)
        
        set @frommarker = @tomarker + 1
    end

	select Item from #SplitItems



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_split_varchar] TO PUBLIC
GO