if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_report_ThreadViewsByDay]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_report_ThreadViewsByDay]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

create procedure [dbo].cs_report_ThreadViewsByDay
(
	@SectionID int = -1,
	@PostID int = -1,
	@ApplicationType smallint = -1,
	@Days int
)	
as
begin
	declare @StartDate as datetime

	set @StartDate = (select convert(char(10), dateadd(day, -@Days, getdate()), 120 ))

	if (@PostID > 0)
	begin
		declare @ThreadID as int

		set @ThreadID = (SELECT ThreadID from cs_Posts where PostID = @PostID)

		select
			S.SectionID,
			S.[Day],
			S.ThreadID,
			S.ViewCount
		from
			cs_Thread_Daily_Stats S
		where
			S.SectionID = @SectionID and
			S.ThreadID = @ThreadID and
			S.[Day] > @StartDate
		order by
			[Day]
	end
	else if (@SectionID > 0)
		select
			S.SectionID,
			S.[Day],
			S.ThreadID,
			S.ViewCount
		from
			cs_Thread_Daily_Stats S
		where
			S.SectionID = @SectionID and
			S.[Day] > @StartDate
		order by
			[Day]
	else if (@ApplicationType > -1)
		select
			-1 as SectionID,
			S.[Day],
			-1 as ThreadID,
			sum(S.ViewCount) as ViewCount
		from
			cs_Thread_Daily_Stats S
			inner join cs_Sections SS on SS.SectionID = S.SectionID
		where
			SS.ApplicationType = @ApplicationType and
			S.[Day] > @StartDate
		group by
			S.[Day]		
		order by 
			[Day]
	else
		select
			-1 as SectionID,
			S.[Day],
			-1 as ThreadID,
			sum(S.ViewCount) as ViewCount
		from
			cs_Thread_Daily_Stats S
		where
			S.[Day] > @StartDate
		group by
			S.[Day]		
		order by 
			[Day]
end
go

grant execute on [dbo].[cs_report_ThreadViewsByDay] to [public]
go
