SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_UpdatePageTags]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_UpdatePageTags]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_UpdatePageTags]
(
	@pageId int,
	@tagXml ntext
)
AS
BEGIN
		DECLARE @iDoc int

		DECLARE @Tags TABLE
		(
			Name nvarchar(256) COLLATE DATABASE_DEFAULT NOT NULL
		)
		
		EXECUTE sp_xml_preparedocument @iDoc OUTPUT, @tagXml

		INSERT INTO
			@Tags
			(
				Name
			)
		SELECT
			CONVERT(nvarchar(255), X.[text])
		FROM
			OPENXML(@iDoc, '/tags/tag/', 2) X
		WHERE
			X.[text] IS NOT NULL

		EXEC sp_xml_removedocument @iDoc

		INSERT INTO
			cs_Wiki_Tags
			(
				Name
			)
		SELECT
			X.Name
		FROM
			@Tags X
		WHERE
			NOT EXISTS
			(
				SELECT 1
				FROM
					cs_Wiki_Tags T
				WHERE
					X.Name = T.Name
			)

		INSERT INTO
			cs_Wiki_PageTags
			(
				PageId,
				TagId
			)
		SELECT
			@pageId,
			T.TagId
		FROM
			cs_Wiki_Tags T
		WHERE
			EXISTS
			(
				SELECT 1
				FROM @Tags X
				where
					T.Name = X.Name
			)
			AND NOT EXISTS
			(
				SELECT 1
				FROM
					cs_Wiki_PageTags PT
				WHERE
					PT.PageId = @pageId
					AND PT.TagId = T.TagId
			)

		DELETE
			PT
		FROM
			cs_Wiki_PageTags PT
		WHERE
			PT.PageId = @pageId
			AND NOT EXISTS
			(
				SELECT 1
				FROM
					cs_Wiki_Tags T
					INNER JOIN @Tags X ON T.Name = X.Name
				WHERE
					T.TagId = PT.TagId
			)
END
GO

SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

grant execute on [dbo].[cs_Wiki_UpdatePageTags] to public
go
