SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_UpdatePage]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_UpdatePage]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_UpdatePage]
(
    @pageId int,
    @wikiId int,
    @userId int,
    @parentPageId int = NULL,
    @title nvarchar(256),
    @pageKey nvarchar(256),
    @body ntext,
    @formattedBody ntext,
    @tagXml ntext,
    @isPublished bit,
    @ratingCount int,
    @ratingSum int,
    @lastModifiedUtcDate datetime, 
    @isLocked bit = 0,
    @isindexed bit = 0,
    @saveRevision bit = 1
)
AS
BEGIN
	IF @parentPageId = -1
		SET @parentPageId = NULL

	-- If PageKey is null/blank, then use PageID as the default for now
	IF ((@pageKey is NULL) OR (LEN(@pageKey) = 0))
		SET @pageKey = CAST(@pageId AS nvarchar(256))

	IF @saveRevision = 1
	BEGIN
	
		DECLARE @revNumber int
		SELECT @revNumber = IsNull(MAX(RevisionNumber), 0) FROM cs_Wiki_PageRevisions WHERE PageId = @pageId
		SET @revNumber = @revNumber + 1

		DECLARE @pagetags AS VARCHAR(MAX)
		SELECT @pagetags = COALESCE(@pagetags + ', ', '') + T.[Name]
		FROM
			cs_Wiki_Tags T
			INNER JOIN cs_Wiki_PageTags PT ON T.TagId = PT.TagId
			INNER JOIN cs_Wiki_Pages P ON P.PageId = PT.PageId
		WHERE
			PT.PageId = @pageId	
		SELECT @pagetags = COALESCE(@pagetags, '')
		
		INSERT INTO
			cs_Wiki_PageRevisions
			(
				PageId,
				UserId,
				Title,
				Body,
				FormattedBody,
				Tags,
				LastModifiedUtcDate,
				RevisionNumber,
				PageKey
			)
		SELECT
			P.PageId,
			P.UserId,
			P.Title,
			P.Body,
			P.FormattedBody,
			@pagetags,
			P.LastModifiedUtcDate,
			@revNumber,
			P.PageKey
		FROM
			cs_Wiki_Pages P
		WHERE
			P.PageId = @pageId
	END

	UPDATE
		cs_Wiki_Pages
	SET
		WikiId = @wikiId,
		UserId = @userId,
		ParentPageId = @parentPageId,
		Title = @title,
		PageKey = @pageKey,
		Body = @body,
		FormattedBody = @formattedBody,
		IsPublished = @isPublished,
		RatingCount = @ratingCount,
		RatingSum = @ratingSum,
		LastModifiedUtcDate = @lastModifiedUtcDate,
		IsLocked = @isLocked,
		IsIndexed = @isindexed,
		RevisionCount = (SELECT     COALESCE (COUNT(r.PageRevisionId), 0) AS cnt
			FROM          cs_Wiki_PageRevisions r
			WHERE r.PageId = [cs_Wiki_Pages].PageId) + 1
	WHERE
		PageId = @pageId

	EXECUTE cs_Wiki_UpdatePageTags @pageId, @tagXml
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_UpdatePage] TO PUBLIC
GO

