SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_ReindexPages]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_ReindexPages]
GO


CREATE PROCEDURE [dbo].[cs_Wiki_ReindexPages]
(
	@WikiId	int = -1,
	@SettingsId int
)
AS
	IF (@WikiId > -1)
	BEGIN
		INSERT cs_es_Search_RemoveQueue (PostID, SettingsID, ApplicationType) 
		SELECT PageId, @SettingsId, 'Wiki' 
		FROM [cs_Wiki_Pages] 
		WHERE WikiId = @WikiId
		AND PageId NOT IN (SELECT PostID FROM cs_es_Search_RemoveQueue WHERE ApplicationType = 'Wiki')

		UPDATE cs_Wiki_Pages set IsIndexed = 0
		WHERE WikiId = @WikiId
	END
GO


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Wiki_ReindexPages] to public
go