SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetTags]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetTags]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetTags]
(
    @wikiId int,
    @tagXml ntext = NULL
)
AS
BEGIN


IF @tagXml IS NULL
BEGIN

	SELECT t.[Name], count(*) as TotalCount
	FROM cs_Wiki_Tags t
		inner join cs_Wiki_PageTags pt on t.TagId = pt.TagId
		inner join cs_wiki_Pages p on pt.PageId = p.PageId
	WHERE
		(p.WikiId = @wikiId OR @wikiId = -1)
		AND p.IsPublished = 1
	GROUP BY t.[Name]
	ORDER BY t.[Name]

END ELSE BEGIN

	DECLARE @iDoc int
	DECLARE @Tags TABLE
	(
		--Name nvarchar(256) COLLATE DATABASE_DEFAULT NOT NULL primary key
		TagId int NOT NULL primary key
	)

	EXECUTE sp_xml_preparedocument @iDoc OUTPUT, @tagXml

	INSERT INTO @Tags ([TagId])
	SELECT t.[TagId]--CONVERT(nvarchar(255), X.[text])
	FROM OPENXML(@iDoc, '/tags/tag/', 2) X
	INNER JOIN cs_Wiki_Tags t
		ON CONVERT(nvarchar(255), X.[text]) = t.[Name]
		AND X.[text] IS NOT NULL

	EXEC sp_xml_removedocument @iDoc
	
	SELECT t.[Name], count(*) as TotalCount
	FROM cs_Wiki_Tags t
		INNER JOIN cs_Wiki_PageTags pt on t.TagId = pt.TagId
		INNER JOIN cs_Wiki_Pages p on pt.PageId = p.PageId AND p.IsPublished = 1
		INNER JOIN (
			SELECT P.PageId
			FROM cs_Wiki_Pages P
				INNER JOIN cs_Wiki_PageTags PT on P.PageId = PT.PageId
				INNER JOIN cs_Wiki_Tags WT on PT.TagId = WT.TagId
				INNER JOIN @Tags T on WT.[TagId] = T.[TagId]
			WHERE ((P.WikiId = @wikiId) OR (@wikiId = -1)) AND p.IsPublished = 1
		) PIDs on PIDs.PageId = p.PageId
	WHERE
		NOT EXISTS (
			SELECT 1 FROM @Tags fTags
			WHERE fTags.[TagId] = t.[TagId]
		)
	GROUP BY t.[Name]
	ORDER BY t.[Name]

END

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetTags] TO PUBLIC
GO
