-- exec cs_Section_Permissions_Get 1000, 0
SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cs_Wiki_GetPermissions]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_GetPermissions]
GO

create procedure [dbo].[cs_Wiki_GetPermissions]
(
	@WikiId int = 0,
	@AllRoles ntext = NULL
)
AS
begin

	DECLARE @ApplicationType smallint
	SELECT @ApplicationType = ApplicationType FROM cs_ApplicationType WHERE ApplicationName = 'Wiki'

	SET Transaction Isolation Level Read UNCOMMITTED
	
	IF (@WikiId = 0)
	begin
		-- Return product permissions
		SELECT 
			Implied = convert(bit, 1), 
			WikiId = -1,
			PP.RoleID as RoleId, 
			AllowMask = convert(bigint, coalesce(PP.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(PP.DenyMask, 0x00))
		FROM
			cs_ProductPermissions PP
		WHERE 
			(PP.ApplicationType = @ApplicationType or @ApplicationType is null)
	
		UNION ALL
	
		-- Return wiki permissions
		SELECT
			Implied = convert(bit, 0), 
			WP.WikiId,
			WP.RoleId, 
			AllowMask = convert(bigint, coalesce(WP.AllowMask, 0x00)),  
			DenyMask = convert(bigint, coalesce(WP.DenyMask, 0x00))
		FROM 
			cs_Wiki_Permissions WP
		order by Implied asc, WikiId desc
	
	end
	ELSE IF (@WikiId > 0)
	begin
		
		-- Return product permissions
		SELECT 
			Implied = convert(bit, 1), 
			WikiId = -1,
			PP.RoleID as RoleId, 
			AllowMask = convert(bigint, coalesce(PP.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(PP.DenyMask, 0x00))
		FROM
			cs_ProductPermissions PP
		WHERE 
			(PP.ApplicationType = @ApplicationType or @ApplicationType is null)
	
		UNION ALL
		
		-- Return wiki permissions
		SELECT
			Implied = convert(bit, 0), 
			WP.WikiId,
			WP.RoleId, 
			AllowMask = convert(bigint, coalesce(WP.AllowMask, 0x00)),  
			DenyMask = convert(bigint, coalesce(WP.DenyMask, 0x00))
		FROM 
			cs_Wiki_Permissions WP
		WHERE
			WP.WikiId = @WikiId
		order by Implied asc, WikiId DESC
	end 
    	ELSE 
	begin
	
	    DECLARE @Roles		table(RoleId uniqueidentifier NOT NULL PRIMARY KEY)
	    DECLARE @Num		int
	    DECLARE @Pos		int
	    DECLARE @NextPos	int
	    DECLARE @guid		nvarchar(256)
	
	    DECLARE @textpos  int --our chunks position in the ntext
	    DECLARE @chunklen smallint
	    DECLARE @chunk   nvarchar(4000)
	    DECLARE @delimiter nvarchar(1)
	    DECLARE @leftover nvarchar(4000)
	
		SET @delimiter = N','
		SET @Num = 0
		SET @textpos = 1
		SET @leftover = ''
	
		WHILE @textpos <= DATALENGTH(@AllRoles) /2
		BEGIN
	
			SET @chunklen = 4000 - DATALENGTH(@leftover) /2
			SET @chunk = ltrim(@leftover + substring(@AllRoles, @textpos, @chunklen))
			SET @textpos = @textpos + @chunklen
	
			SET @Pos = 1 
	
			WHILE(@Pos <= DATALENGTH(@chunk))
			BEGIN
				SELECT @NextPos = CHARINDEX(@delimiter, @chunk,  @Pos)
				IF (@NextPos = 0 OR @NextPos IS NULL)
				BEGIN
					--break us from the loop
					SELECT @NextPos = DATALENGTH(@chunk) + 1
					--set the leftover string to use again in next iter
					SET @leftover = LOWER(RTRIM(LTRIM(SUBSTRING(@chunk, @Pos, @NextPos - @Pos))))
				END
				ELSE
				BEGIN
					SELECT @guid = LOWER(RTRIM(LTRIM(SUBSTRING(@chunk, @Pos, @NextPos - @Pos))))
	
					INSERT INTO @Roles VALUES (CONVERT(uniqueidentifier, @guid))
	
					SET @Num = @Num + 1
				END
	
				SELECT @Pos = @NextPos+1
			END
	
			IF(@Pos = DATALENGTH(@chunk))
				SET @leftover = ''
		END
	
		INSERT INTO @Roles VALUES (CONVERT(uniqueidentifier, @leftover))
	
	
		-- Return product permissions
		SELECT 
			Implied = convert(bit, 1), 
			WikiId = -1,
			R.RoleId, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00))
		FROM
			@Roles R
			left outer join cs_ProductPermissions P on R.RoleId = P.RoleID and (P.ApplicationType = @ApplicationType or @ApplicationType is null)
	end
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Wiki_GetPermissions] to public
go