SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPagesIndexed]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPagesIndexed]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPagesIndexed]
(
    @isIndexed bit = 0,
    @totalCount int OUTPUT
)
AS
BEGIN
	SELECT
		P.PageId,
		P.WikiId,
		P.UserId,
		P.ParentPageId,
		P.Title,
		P.PageKey,
		P.Body,
		P.FormattedBody,
		P.IsPublished,
		P.RatingCount,
		P.RatingSum,
		P.LastModifiedUtcDate, 
		P.RevisionCount, 
		P.IsLocked,
		P.IsIndexed,
		P.TotalViews
	FROM
		cs_Wiki_Pages P
		INNER JOIN [cs_Wiki_Wikis] W ON W.WikiId = P.WikiId
	WHERE
		P.[IsIndexed] = @isIndexed AND
		P.[IsPublished] = 1 AND
		W.[IsEnabled] = 1

	SET @totalCount = @@ROWCOUNT

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPagesIndexed] TO PUBLIC
GO