SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPagesByTags]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPagesByTags]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPagesByTags]
(
    @wikiId int = -1,
    @pageIndex int,
    @pageSize int,
    @tagXml ntext = NULL,
    @totalCount int OUTPUT
)
AS
BEGIN

	DECLARE @rowsToReturn int
	DECLARE @pageLowerBound int
	DECLARE @pageUpperBound int
	DECLARE @tagCount int

	DECLARE @iDoc int
	DECLARE @Tags TABLE
	(
		Name nvarchar(256) COLLATE DATABASE_DEFAULT NOT NULL
	)

	EXECUTE sp_xml_preparedocument @iDoc OUTPUT, @tagXml

	INSERT INTO @Tags (Name)
	SELECT CONVERT(nvarchar(255), X.[text])
	FROM OPENXML(@iDoc, '/tags/tag/', 2) X
	WHERE X.[text] IS NOT NULL

	SET @tagCount = @@ROWCOUNT

	EXEC sp_xml_removedocument @iDoc

	declare @Results table
	(
		IndexId int IDENTITY(1, 1) NOT NULL,
		PageId int NOT NULL
	)

	INSERT INTO @Results
		(PageId)
	select PageId from (
	SELECT
		P.PageId, P.LastModifiedUtcDate
	FROM
		cs_Wiki_Pages P
	INNER JOIN
		cs_Wiki_Wikis W on P.WikiId = W.WikiId
	WHERE
		(P.WikiId = @wikiId OR (@wikiId = -1 and W.HubId is null))
		AND W.IsEnabled = 1
		AND EXISTS (
			SELECT 1 FROM cs_Wiki_PageTags PT
			INNER JOIN
				cs_Wiki_Tags WT on PT.TagId = WT.TagId
			INNER JOIN
				@Tags T on WT.[Name] = T.[Name]
			WHERE
				P.PageId = PT.PageId
			GROUP BY
				PT.PageId
			HAVING
				/* this says to only get posts that have at least all of the tags we are requesting */
				COUNT(*) >= @tagCount
		)
	) as z
	ORDER BY
		LastModifiedUtcDate DESC

	SET @totalCount = @@ROWCOUNT

	exec [dbo].[cs_system_CalculatePagingInformation]
		@pageIndex, @pageSize
		, @rowsToReturn output, @pageLowerBound output, @pageUpperBound output

	SET ROWCOUNT @rowsToReturn

	SELECT
		P.PageId,
		P.WikiId,
		P.UserId,
		P.ParentPageId,
		P.Title,
		P.PageKey,
		P.Body,
		P.FormattedBody,
		P.IsPublished,
		P.RatingCount,
		P.RatingSum,
		P.LastModifiedUtcDate, 
		P.RevisionCount, 
		P.IsLocked,
		P.IsIndexed,
		P.TotalViews
	FROM
		cs_Wiki_Pages P
		INNER JOIN @Results R ON P.PageId = R.PageId
	WHERE
		R.IndexId > @pageLowerBound
		AND R.IndexId < @pageUpperBound
	ORDER BY
		IndexId

	SET ROWCOUNT 1000

	SELECT
		T.[Name], R.PageId as TagPageId, (select count(TagId) from cs_Wiki_PageTags WPT where WPT.PageId = R.PageId) as PageTagCount
	FROM
		cs_Wiki_Tags T
		INNER JOIN cs_Wiki_PageTags PT ON T.TagId = PT.TagId
		INNER JOIN @Results R ON PT.PageId = R.PageId
	ORDER BY
		[Name] ASC

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPagesByTags] TO PUBLIC
GO
