SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPages]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPages]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPages]
(
    @wikiId int,
    @pageIndex int,
    @pageSize int,
    @isPublished bit = NULL,
    @userId int = NULL,
    @isNew bit = NULL,
    @totalCount int OUTPUT
)
AS
BEGIN

	DECLARE @rowsToReturn int
	DECLARE @pageLowerBound int
	DECLARE @pageUpperBound int

	declare @Results table
	(
		IndexId int IDENTITY(1, 1) NOT NULL,
		PageId int NOT NULL
	)

	INSERT INTO @Results
		(PageId)
	select PageId from (
	SELECT
		P.PageId, P.LastModifiedUtcDate
	FROM
		cs_Wiki_Pages P
		INNER JOIN cs_Wiki_Wikis W on P.WikiId = W.WikiId
	WHERE
		(P.WikiId = @wikiId OR (@wikiId = -1 and W.HubId is null))
		AND W.IsEnabled = 1
		AND (@isPublished IS NULL OR P.IsPublished = @isPublished)
		AND (@userId IS NULL OR P.UserId = @userId OR P.PageId in (SELECT PR.PageId FROM cs_Wiki_PageRevisions PR WHERE PR.UserId = @userId))
		AND (@isNew IS NULL OR 
			(@isNew = 0 AND P.PageId in (SELECT PR.PageId FROM cs_Wiki_PageRevisions PR)) OR
			(@isNew = 1 AND P.PageId not in (SELECT PR.PageId FROM cs_Wiki_PageRevisions PR)))
	) as z
	ORDER BY
		LastModifiedUtcDate DESC

	SET @totalCount = @@ROWCOUNT

	exec [dbo].[cs_system_CalculatePagingInformation]
		@pageIndex, @pageSize
		, @rowsToReturn output, @pageLowerBound output, @pageUpperBound output

	SET ROWCOUNT @rowsToReturn

	SELECT
		P.PageId,
		P.WikiId,
		P.UserId,
		P.ParentPageId,
		P.Title,
		P.PageKey,
		P.Body,
		P.FormattedBody,
		P.IsPublished,
		P.RatingCount,
		P.RatingSum,
		P.LastModifiedUtcDate, 
		P.RevisionCount, 
		P.IsLocked,
		P.IsIndexed,
		P.TotalViews
	FROM
		cs_Wiki_Pages P
		INNER JOIN @Results R ON P.PageId = R.PageId
	WHERE
		R.IndexId > @pageLowerBound
		AND R.IndexId < @pageUpperBound

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPages] TO PUBLIC
GO
