
SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPageRevision]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPageRevision]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPageRevision]
(
    @pageId int,
    @revisionNumber int
)
AS
BEGIN

	SELECT
		PR.PageRevisionId,
		PR.PageId,
		PR.UserId,
		PR.Title,
		PR.PageKey,
		PR.Body,
		PR.FormattedBody,
		PR.Tags,
		PR.LastModifiedUtcDate,
		PR.RevisionNumber
	FROM
		cs_Wiki_PageRevisions PR
	WHERE
		PR.PageId = @pageId
		AND PR.RevisionNumber = @revisionNumber

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPageRevision] TO PUBLIC
GO
