SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_GetPageFollowers]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_GetPageFollowers]
GO

CREATE PROCEDURE [dbo].cs_Wiki_GetPageFollowers
(
	@PageId int,
	@UserId int = -1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED

SELECT
	U.UserID,
	U.Email, 
	U.EnableHtmlEmail,
	U.[PublicToken],
	U.[UserName]
FROM 
	cs_Wiki_PageFollowers F
	INNER JOIN cs_vw_Users_FullUser U (nolock) ON U.UserID = F.UserId
WHERE
	F.PageId = @PageId
	and (F.UserId = @UserId OR @UserId = -1)
	and U.EnableEmail = 1
	and U.UserAccountStatus = 1

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Wiki_GetPageFollowers] to public
go
