SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPageCommentsByWiki]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPageCommentsByWiki]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPageCommentsByWiki]
(
    @wikiID int,
    @pageIndex int,
    @pageSize int,
    @sortBy nvarchar (256), 
    @sortOrder nvarchar (256), 
    @totalCount int OUTPUT
)
AS
BEGIN

	DECLARE @rowsToReturn int
	DECLARE @pageLowerBound int
	DECLARE @pageUpperBound int

	/* this sproc will eventually need to be setup with partial paging */

	declare @Results table
	(
		IndexId int IDENTITY(1, 1) NOT NULL,
		PageCommentId int NOT NULL
	)

	IF ((@sortBy is NULL) OR (LEN(@sortBy) = 0))
		BEGIN
			SET @sortBy = 'PublishedDate';
		END
        IF ((@sortOrder is NULL) OR (LEN(@sortOrder) = 0))
		BEGIN
			SET @sortOrder = 'Ascending';
		END

	IF (@sortBy = 'RatingAverage') 
		BEGIN
			-- By RatingAverage (desc only, no asc)
			INSERT INTO @Results
				(PageCommentId)
			SELECT
				PC.PageCommentId
			FROM
				cs_Wiki_PageComments PC inner join cs_Wiki_Pages P on P.PageId = PC.PageId
			WHERE
				P.WikiId = @wikiID
			ORDER BY
				(PC.RatingSum / (PC.RatingCount + .1)) DESC, PC.RatingCount, PC.RatingSum
		END
	
	ELSE
		BEGIN 
			IF (@sortBy='MostRecent' OR (@sortBy = 'PublishedDate' AND @sortOrder = 'Descending'))
				BEGIN
					-- By PublishedDate Desc
					INSERT INTO @Results
						(PageCommentId)
					SELECT
						PC.PageCommentId
					FROM
						cs_Wiki_PageComments PC inner join cs_Wiki_Pages P on P.PageId = PC.PageId
					WHERE
						P.WikiId = @wikiID
					ORDER BY
						PC.PublishedUtcDate DESC
				END
			ELSE 
				BEGIN
					-- The Default by PublishedDate asc
					INSERT INTO @Results
						(PageCommentId)
					SELECT
						PC.PageCommentId
					FROM
						cs_Wiki_PageComments PC inner join cs_Wiki_Pages P on P.PageId = PC.PageId
					WHERE
						P.WikiId = @wikiID
					ORDER BY
						PC.PublishedUtcDate ASC
				END
		END

	SET @totalCount = @@ROWCOUNT

	exec [dbo].[cs_system_CalculatePagingInformation]
		@pageIndex, @pageSize
		, @rowsToReturn output, @pageLowerBound output, @pageUpperBound output

	SET ROWCOUNT @rowsToReturn

	SELECT
		PC.PageCommentId,
		PC.PageId,
		PC.UserId,
		PC.Body,
		PC.FormattedBody,
		PC.RatingCount,
		PC.RatingSum,
		PC.PublishedUtcDate
	FROM
		cs_Wiki_PageComments PC
		INNER JOIN @Results R ON PC.PageCommentId = R.PageCommentId
	WHERE
		R.IndexId > @pageLowerBound
		AND R.IndexId < @pageUpperBound
END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPageCommentsByWiki] TO PUBLIC
GO
