SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_GetPage]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_GetPage]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_GetPage]
(
    @pageId int
)
AS
BEGIN
	SELECT
		P.PageId,
		P.WikiId,
		P.UserId,
		P.ParentPageId,
		P.Title,
		P.PageKey,
		P.Body,
		P.FormattedBody,
		P.IsPublished,
		P.RatingCount,
		P.RatingSum,
		P.LastModifiedUtcDate, 
		P.RevisionCount, 
		P.IsLocked,
		P.IsIndexed,
		P.TotalViews
	FROM
		cs_Wiki_Pages P
		INNER JOIN cs_Wiki_Wikis W on W.WikiId = P.WikiId
	WHERE
		W.IsEnabled = 1 
		AND P.PageId = @pageId

	SELECT
		T.[Name]
	FROM
		cs_Wiki_Tags T
		INNER JOIN cs_Wiki_PageTags PT ON T.TagId = PT.TagId
		INNER JOIN cs_Wiki_Pages P ON P.PageId = PT.PageId
		INNER JOIN cs_Wiki_Wikis W on W.WikiId = P.WikiId
	WHERE
		W.IsEnabled = 1 
		AND PT.PageId = @pageId
	ORDER BY
		T.[Name] ASC
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_GetPage] TO PUBLIC
GO

