SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_FollowPage]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_FollowPage]
GO

CREATE PROCEDURE [dbo].cs_Wiki_FollowPage
(
	@PageId int,
	@UserId int,
	@Follow bit
)
AS

SET Transaction Isolation Level Read UNCOMMITTED


IF (@Follow = 1)
BEGIN
	-- Insert row if one doesn't exist
	IF NOT EXISTS(SELECT PageId FROM cs_Wiki_PageFollowers (nolock) WHERE PageId = @PageId AND UserId = @UserId)
	BEGIN
		INSERT INTO cs_Wiki_PageFollowers (PageId, UserId)
		VALUES (@PageId, @UserId)
	END
END
ELSE
BEGIN
	DELETE cs_Wiki_PageFollowers
	WHERE PageId = @PageId
		and UserId = @UserId
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].cs_Wiki_FollowPage to public
go
