SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_DeletePermission]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_DeletePermission]
GO

CREATE  procedure [dbo].cs_Wiki_DeletePermission
(
	@WikiId 	int,
	@RoleId		uniqueidentifier,
	@SettingsId	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	DECLARE @ApplicationType smallint
	SELECT @ApplicationType = ApplicationType FROM cs_ApplicationType WHERE ApplicationName = 'Wiki'
	
	IF (@WikiId <> -1)
		DELETE FROM cs_Wiki_Permissions WHERE WikiId = @WikiId AND RoleId = @RoleId
	ELSE
	begin
		DELETE FROM cs_Wiki_Permissions WHERE RoleId = @RoleId
		DELETE FROM cs_ProductPermissions WHERE RoleID = @RoleId and SettingsID = @SettingsId and ApplicationType = @ApplicationType
	end

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_DeletePermission] TO PUBLIC
GO