SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Wiki_AddPermission]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Wiki_AddPermission]
GO

CREATE  procedure [dbo].cs_Wiki_AddPermission
(
	@WikiId 	int,
	@RoleId		uniqueidentifier,
	@AllowMask	bigint,
	@DenyMask	bigint,
	@SettingsId	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	DECLARE @ApplicationType smallint
	SELECT @ApplicationType = ApplicationType FROM cs_ApplicationType WHERE ApplicationName = 'Wiki'
	
	IF (@WikiId <> -1) 
	begin
		IF EXISTS (SELECT WikiId FROM cs_Wiki_Permissions WHERE WikiId = @WikiId AND RoleId = @RoleId)
			exec cs_Wiki_UpdatePermission @WikiId, @RoleId, @AllowMask, @DenyMask, @SettingsId
		ELSE
			INSERT INTO 
				cs_Wiki_Permissions (WikiId, RoleId, AllowMask, DenyMask)
			VALUES	(
					@WikiId,
					@RoleId,
					@AllowMask,
					@DenyMask
				)
	
		IF NOT EXISTS(SELECT * FROM cs_ProductPermissions WHERE SettingsID = @SettingsId and RoleID = @RoleId and ApplicationType = @ApplicationType)
			INSERT INTO cs_ProductPermissions (SettingsID, RoleID, AllowMask, DenyMask, ApplicationType)
				VALUES (@SettingsId, @RoleId, 0x0, 0x0, @ApplicationType)
	end
	ELSE
	begin
		IF NOT EXISTS(SELECT * FROM cs_ProductPermissions WHERE SettingsID = @SettingsId and RoleID = @RoleId and ApplicationType = @ApplicationType)
			INSERT INTO cs_ProductPermissions (SettingsID, RoleID, AllowMask, DenyMask, ApplicationType)
				VALUES (@SettingsId, @RoleId, @AllowMask, @DenyMask, @ApplicationType)
		ELSE
			exec cs_Wiki_UpdatePermission @WikiId, @RoleId, @AllowMask, @DenyMask, @SettingsId
	end

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_AddPermission] TO PUBLIC
GO