SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Wiki_AddPage]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Wiki_AddPage]
GO

CREATE PROCEDURE [dbo].[cs_Wiki_AddPage]
(
    @pageId int OUTPUT,
    @wikiId int,
    @userId int,
    @parentPageId int = NULL,
    @title nvarchar(256),
    @pageKey nvarchar(256),
    @body ntext,
    @formattedBody ntext,
    @tagXml ntext,
    @isPublished bit,
    @ratingCount int,
    @ratingSum int,
    @lastModifiedUtcDate datetime, 
    @revisionCount int = 1, 
    @isLocked bit = 0,
    @isIndexed bit = 0
)
AS
BEGIN
	IF @parentPageId = -1
		SET @parentPageId = NULL

	INSERT INTO
		cs_Wiki_Pages
		(
			WikiId,
			UserId,
			ParentPageId,
			Title,
			PageKey,
			Body,
			FormattedBody,
			IsPublished,
			RatingCount,
			RatingSum,
			LastModifiedUtcDate, 
			RevisionCount, 
			IsLocked,
			IsIndexed
		)
	VALUES
	(
		@wikiId,
		@userId,
		@parentPageId,
		@title,
		@pageKey,
		@body,
		@formattedBody,
		@isPublished,
		@ratingCount,
		@ratingSum,
		@lastModifiedUtcDate,
		@revisionCount, 
		@isLocked,
		@isIndexed
	)

	SET @pageId = scope_identity()

	-- If PageKey is null/blank, then use PageID as the default for now
	IF ((@pageKey is NULL) OR (LEN(@pageKey) = 0))
	BEGIN
		UPDATE cs_Wiki_Pages
		SET PageKey = CAST(@pageId AS nvarchar(256))
		WHERE PageId = @pageId
	END

	EXECUTE cs_Wiki_UpdatePageTags @pageId, @tagXml
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Wiki_AddPage] TO PUBLIC
GO
