SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_WeblogContactRequests_Get]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_WeblogContactRequests_Get]
GO

CREATE PROCEDURE [dbo].[cs_WeblogContactRequests_Get]
(
    @WeblogId int,
    @IsModerated bit = NULL,
    @PageIndex int,
    @PageSize int,
    @TotalCount int OUTPUT
)
AS
BEGIN

	DECLARE @rowsToReturn int
	DECLARE @pageLowerBound int
	DECLARE @pageUpperBound int

	CREATE TABLE #Results
	(
		IndexId int IDENTITY(1, 1) NOT NULL,
		Id int NOT NULL
	)

	INSERT INTO #Results
		(Id)
	SELECT
		CR.Id
	FROM
		[dbo].[cs_Weblog_ContactRequests] CR
	WHERE
		CR.WeblogId = @WeblogId
		AND (@IsModerated IS NULL OR CR.IsModerated = @IsModerated)
	ORDER BY
		CR.CreationDate DESC

	SET @TotalCount = @@ROWCOUNT

	SET @rowsToReturn = @PageSize * (@PageIndex + 1)
	SET @pageLowerBound = @PageSize * @PageIndex
	SET @pageUpperBound = @pageLowerBound + @PageSize + 1

	SET ROWCOUNT @rowsToReturn

	SELECT
		CR.Id,
		CR.WeblogId,
		CR.Subject,
		CR.Name,
		CR.EmailAddress,
		CR.CreationDate,
		CR.Body,
		CR.IsModerated
	FROM
		[dbo].[cs_Weblog_ContactRequests] CR
		INNER JOIN #Results R ON CR.Id = R.Id
	WHERE
		R.IndexId > @pageLowerBound
		AND R.IndexId < @pageUpperBound

	DROP TABLE #Results
END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_WeblogContactRequests_Get] TO PUBLIC
GO