SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_UnsubscribeFromThread]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_UnsubscribeFromThread]
GO

CREATE procedure dbo.cs_UnsubscribeFromThread
(
	@UserID int,
	@PostID	int,
	@SettingsID int
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	DECLARE @ThreadID INT
	
	-- First get the post info
	SELECT 
		@ThreadID = ThreadID
	FROM 
		cs_Posts (nolock) 
	WHERE 
		PostID = @PostID and SettingsID = @SettingsID
		
	IF EXISTS(SELECT ThreadID FROM cs_TrackedThreads WHERE ThreadID = @ThreadID AND UserID = @UserID and SettingsID = @SettingsID)
		-- the user is tracking this thread, delete this row
		DELETE FROM cs_TrackedThreads
		WHERE ThreadID = @ThreadID AND UserID = @UserID and SettingsID = @SettingsID	

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_UnsubscribeFromThread] to public
