SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_UnsubscribeFromSection]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_UnsubscribeFromSection]
GO

CREATE procedure dbo.cs_UnsubscribeFromSection
(
	@SubscriptionID uniqueidentifier,
	@SectionID int OUTPUT
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	-- Include the check for DateUnsubscribed so that a user can only be unsubscribed once
	UPDATE [cs_SectionSubscriptions]
	SET DateUnsubscribed = GetDate(), IsConfirmed = 0
	WHERE SubscriptionID = @SubscriptionID AND DateUnsubscribed IS NULL
	
	SELECT @SectionID = SectionID FROM [cs_SectionSubscriptions] 
	WHERE SubscriptionID = @SubscriptionID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_UnsubscribeFromSection] to public
