SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[cs_Thread_GetTrackedCount]') AND OBJECTPROPERTY(id, N'IsProcedure') = 1)
DROP PROCEDURE [dbo].[cs_Thread_GetTrackedCount]
GO

CREATE PROCEDURE [dbo].[cs_Thread_GetTrackedCount]
(
	@SettingsID int,
	@ThreadID int,
	@TrackedCount int output
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN

Set @TrackedCount = (Select Coalesce(Count(cs_TrackedThreads.UserID),0) FROM cs_TrackedThreads (nolock) WHERE ThreadID = @ThreadID AND SettingsID = @SettingsID);
Select @TrackedCount;

END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Thread_GetTrackedCount] TO PUBLIC
GO