SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Thread_Daily_Stats_Increment]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Thread_Daily_Stats_Increment]
GO

Create PROCEDURE [dbo].[cs_Thread_Daily_Stats_Increment]
(
	@SectionID as int,
	@ThreadID as int,
	@ViewCount as int
)
AS
BEGIN
	SET Transaction Isolation Level Read UNCOMMITTED

	DECLARE @day datetime

	Set @day = convert( char(10), GetDate(), 120 )

	-- update daily stats
	UPDATE
		tds
	SET
		tds.ViewCount = tds.ViewCount + @ViewCount
	FROM
		cs_Thread_Daily_Stats tds
	WHERE
		tds.SectionID = @SectionID
		AND tds.ThreadID = @ThreadID
		AND tds.[Day] = @day

	-- if there was nothing to update, add it to the table
	IF @@ROWCOUNT = 0
		-- new stats record
		INSERT INTO cs_Thread_Daily_Stats ([SectionID], [ThreadID], [Day], [ViewCount])
		VALUES (@SectionID, @ThreadID, @day, @ViewCount)

END
GO


grant execute on [dbo].[cs_Thread_Daily_Stats_Increment] to public
go