SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_ThemeConfigurationData_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_ThemeConfigurationData_Update]
GO

CREATE PROCEDURE dbo.cs_ThemeConfigurationData_Update
	@ThemeName nvarchar(255),
	@SettingsID int,
	@SectionID int,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
	@ThemeConfigurationDataTempID uniqueidentifier = null
AS

if (@ThemeConfigurationDataTempID is not null) begin
	if exists(select ThemeName from cs_ThemeConfigurationData_TEMP where ThemeName = @ThemeName and SettingsID = @SettingsID and SectionID = @SectionID and ThemeConfigurationDataTempID = @ThemeConfigurationDataTempID)
	begin
		update cs_ThemeConfigurationData_TEMP
		set PropertyNames = @PropertyNames,
			PropertyValues = @PropertyValues,
			LastModified = getdate()
		where ThemeName = @ThemeName
			and SettingsID = @SettingsID
			and SectionID = @SectionID
			and ThemeConfigurationDataTempID = @ThemeConfigurationDataTempID
	end else begin
		insert into cs_ThemeConfigurationData_TEMP (ThemeName, SettingsID, SectionID, PropertyNames, PropertyValues, ThemeConfigurationDataTempID, LastModified) 
		values (@ThemeName, @SettingsID, @SectionID, @PropertyNames, @PropertyValues, @ThemeConfigurationDataTempID, getdate())
	end
end else begin
	if exists(select ThemeName from cs_ThemeConfigurationData where ThemeName = @ThemeName and SettingsID = @SettingsID and SectionID = @SectionID)
	begin
		update cs_ThemeConfigurationData
		set PropertyNames = @PropertyNames,
			PropertyValues = @PropertyValues
		where ThemeName = @ThemeName
			and SettingsID = @SettingsID
			and SectionID = @SectionID
	end else begin
		insert into cs_ThemeConfigurationData (ThemeName, SettingsID, SectionID, PropertyNames, PropertyValues) 
		values (@ThemeName, @SettingsID, @SectionID, @PropertyNames, @PropertyValues)
	end
end
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_ThemeConfigurationData_Update]  TO [public]
GO

