SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_ThemeConfigurationData_ExpireTemp]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_ThemeConfigurationData_ExpireTemp]
GO

CREATE PROCEDURE dbo.cs_ThemeConfigurationData_ExpireTemp
	@HoursOld int,
	@SettingsID int
AS

declare @ExpireBefore datetime
set @ExpireBefore = dateadd(hour, -@HoursOld, getdate())

delete from cs_ThemeConfigurationData_TEMP
where LastModified < @ExpireBefore
	and SettingsID = @SettingsID
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_ThemeConfigurationData_ExpireTemp]  TO [public]
GO

