SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Tags_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Tags_Get]
GO

CREATE PROCEDURE [dbo].[cs_Tags_Get] 
	@SectionXML ntext = null,
	@CategoryList nvarchar(4000) = null,
	@sqlPopulate ntext = null,
	@SettingsID int
AS
begin
	SET Transaction Isolation Level Read UNCOMMITTED
	DECLARE @Sections TABLE 
	(
		SectionID int
	)
	--DECLARE @FilterSections TABLE 
	--(
	--	SectionID int
	--)
	-- Create a temp table to store the select results
	CREATE TABLE #FilterSections 
	(
		SectionID int  NOT NULL
	)
	
	
	DECLARE @ret int, @iXml int
	
	IF @SectionXML IS NOT NULL
	BEGIN
	
		EXECUTE @ret = [master].[dbo].[sp_xml_preparedocument] @iXml OUTPUT, @SectionXML
	
		INSERT INTO #FilterSections (SectionID)
			SELECT
		    		a.sectionID
			FROM
		    		OPENXML(@iXml, '/xml/SectionIDs/i', 2) -- use element-centric mapping
			WITH ( sectionID int '.') AS a
	
		-- clean up the sqlxml object
		EXEC sp_xml_removedocument @iXml
	END
	
	--SQL POPULATE WAS ADDED TO SUPPORT THE ISPUBLIC FLAG AS AN OPTIONAL ALTERNATE WAY TO POPULATE THE SECTION LIST
	IF @sqlPopulate IS NOT NULL
	BEGIN
	
		INSERT INTO #FilterSections (SectionID)
		EXEC sp_executesql @sqlPopulate
	
	END   
	
	
	INSERT INTO @Sections (SectionID)
			SELECT
			    s.SectionID 
			FROM 
			   #FilterSections fs JOIN cs_Sections s on
			   	s.SettingsID = @SettingsID
			   	and fs.SectionID = s.SectionID
			   	and s.IsActive = 1
	
	DROP TABLE #FilterSections
	
	if @CategoryList is null begin
	
		select [Name], count(*) as TotalCount
		from cs_Post_Categories C
		inner join cs_Posts_InCategories PiC on C.CategoryID = PiC.CategoryID
		inner join cs_Posts P on PiC.PostID = P.PostID
		where C.SettingsID = @SettingsID
			and C.SectionID IN (select sx.SectionID from @Sections sx)
			and P.IsApproved = 1
			and C.IsEnabled = 1
		group by [Name]
		order by [Name]
	
	end else begin
	
		declare @idoc int
		declare @categoryCount int
	
		declare @Tags TABLE
		(
			[Name] nvarchar(255) collate database_default
		)
	
		EXEC sp_xml_preparedocument @idoc OUTPUT, @CategoryList
		
		insert into @Tags ([Name])
		select CONVERT(nvarchar(255), [text])
		from OPENXML(@idoc, '/Categories/Category/', 2)
		where [text] is not null
	
		set @categoryCount = @@ROWCOUNT
	
		-- clean up the sqlxml object
		EXEC sp_xml_removedocument @idoc
	
		select [Name], count(*) as TotalCount
		from cs_Post_Categories C
		inner join cs_Posts_InCategories PiC on C.CategoryID = PiC.CategoryID
		where C.SettingsID = @SettingsID
			and C.SectionID in (select sx.SectionID from @Sections sx)
			and C.IsEnabled = 1
			and PiC.PostID in (
				select P2.PostID
				from @Tags X
				inner join cs_Post_Categories C2 on X.[Name] = C2.Name
				inner join cs_Posts_InCategories PiC2 on PiC2.CategoryID = C2.CategoryID
				inner join cs_Posts P2 on PiC2.PostID = P2.PostID
				where C2.SettingsID = @SettingsID
					and C2.SectionID in (select sx.SectionID from @Sections sx)
					and C2.IsEnabled = 1
					and P2.SettingsID = @SettingsID
					and P2.IsApproved = 1
				group by P2.PostID
				having count(*) = @categoryCount
				)
		group by [Name]
		having [Name] not in (select tx.[Name] from @Tags tx)
		order by [Name]
	
	end
end
go

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_Tags_Get]  TO [public]
GO

