SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SubscribedSection_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SubscribedSection_Get]
GO

CREATE procedure dbo.cs_SubscribedSection_Get
(
	@SectionID int,
	@Email nvarchar(256),
	@SettingsID int
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	SELECT SubscriptionID, DateSubscribed, 
		SubscriptionFrequency as Frequency,
		IsConfirmed, DateUnsubscribed
	FROM cs_SectionSubscriptions
	WHERE
		SectionID = @SectionID AND Email = @Email AND SettingsID = @SettingsID

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_SubscribedSection_Get] to public
