SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SubscribeToSection]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SubscribeToSection]
GO

CREATE procedure dbo.cs_SubscribeToSection
(
	@UserID int,
	@SectionID int,
	@SettingsID int,
	@Email nvarchar(256),
	@SubscriptionType int,
	@SubscriptionID uniqueidentifier OUTPUT
)
AS
	SET Transaction Isolation Level Read UNCOMMITTED

	DECLARE @counter int

	-- check to see if the user is currently subscribed to the section
	IF NOT EXISTS (SELECT SubscriptionID FROM cs_SectionSubscriptions
					WHERE SectionID = @SectionID AND
							SettingsID = @SettingsID AND Email = @Email)
		BEGIN
			SET @SubscriptionID = NEWID()
			-- this user isn't subscribed to the section, so add them
			INSERT INTO cs_SectionSubscriptions (SubscriptionID, SectionID, Email, SubscriptionType, UserID, SettingsID, DateSubscribed, DateUnsubscribed, SubscriptionFrequency)
			VALUES(@SubscriptionID, @SectionID, @Email, @SubscriptionType, @UserID, @SettingsID, GetDate(), NULL, 1)		
		END
	ELSE IF EXISTS (SELECT SubscriptionID FROM cs_SectionSubscriptions
						WHERE	SectionID = @SectionID AND
							SettingsID = @SettingsID AND Email = @Email)
		BEGIN
			-- the subscription exists but is unsubscribed, so subscribe it
			SELECT @counter = SubscriptionFrequency, @SubscriptionID = SubscriptionID 
				FROM cs_SectionSubscriptions 
				WHERE	SectionID = @SectionID AND
					SettingsID = @SettingsID AND Email = @Email AND
					DateUnsubscribed IS NOT NULL
			SET @counter = @counter + 1
		
			UPDATE cs_SectionSubscriptions
			SET DateUnsubscribed = NULL,
				DateSubscribed = GetDate(),
				SubscriptionFrequency = @counter
			WHERE	SectionID = @SectionID AND
					SettingsID = @SettingsID AND Email = @Email AND
					DateUnsubscribed IS NOT NULL
		END

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_SubscribeToSection] to public
