SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SpamPosts_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SpamPosts_Get]
GO

CREATE PROCEDURE [dbo].[cs_SpamPosts_Get]
(
	@SectionID int,
	@SpamStatus int,
	@PageIndex int,
	@PageSize int,
	@TotalRecords int out
)
AS
begin

SET Transaction Isolation Level Read UNCOMMITTED

DECLARE @RowsToReturn int
DECLARE @PageLowerBound int
DECLARE @PageUpperBound int

-- Create a temp table to store the select results
DECLARE @PageTable TABLE
(
	IndexID int IDENTITY (1, 1) NOT NULL,
	SpamPostID bigint not null
)

-- First set the rowcount
SET @RowsToReturn = @PageSize * (@PageIndex + 1)
	
-- Set the page bounds
SET @PageLowerBound = @PageSize * @PageIndex
SET @PageUpperBound = @PageLowerBound + @PageSize + 1

INSERT INTO @PageTable(SpamPostID)
SELECT P.SpamPostID 
FROM cs_SpamPosts P (nolock)
WHERE (P.SectionID = @SectionID) AND (@SpamStatus = -1 OR P.PostStatus & @SpamStatus = @SpamStatus)
ORDER BY PostDate DESC

Set @TotalRecords = @@rowcount

SET ROWCOUNT @RowsToReturn

SELECT 
	Convert(int, P.[SpamPostID]) as PostID, [SectionID], [ParentID], [AllowDuplicatePosts], [DuplicateIntervalInMinutes], [Subject], [UserID], [PostAuthor]
	, [Body], [FormattedBody], [EmoticonID], [IsLocked], [IsSticky], [IsApproved], [StickyDate]
	, [PostType], [PostMedia], [PostDate], [UserHostAddress] as IPAddress, [PropertyNames] as PostPropertyNames, [PropertyValues] as PostPropertyValues, [SettingsID]
	, [IsTracked], [ThreadID], [PostConfiguration], [UpdateSectionStatistics], [UserTime], [ApplicationPostType]
	, [PostName], [ThreadStatus], [Points] as PostPoints, [PostDisplayName], [AutoApprove], [TitleUrl], [PostConfig]
	, [BlogPostType], [Categories], [SpamScore], [PostStatus],
	[PostDate] as ThreadDate,
	Replies = 0, PostLevel = 1,
	TotalViews = 0, AggViews = 0,
	RatingSum = 0, TotalRatings = 0

FROM 
	cs_SpamPosts P (nolock),
	@PageTable pt
WHERE 
	P.SpamPostID = pt.SpamPostID AND
	pt.IndexID > @PageLowerBound AND
	pt.IndexID < @PageUpperBound
ORDER BY
	IndexID


end

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

GRANT EXECUTE ON [dbo].[cs_SpamPosts_Get] TO [public]
GO

