SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SpamPostReviveOne]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SpamPostReviveOne]
GO

CREATE PROCEDURE [dbo].[cs_SpamPostReviveOne]
(
	@SpamPostID bigint = null
	, @RowCount int = null output
)
AS
begin
	SET NOCOUNT ON
	
	declare
		@return_value int
		, @SourceProcedure nvarchar(128)
		/* from cs_Post_CreateUpdate */
		, @SectionID int
		, @ParentID int
		, @AllowDuplicatePosts bit
		, @DuplicateIntervalInMinutes int
		, @Subject nvarchar(256)
		, @UserID int
		, @PostAuthor nvarchar(64)
		, @Body nvarchar(4000) --ntext
		, @FormattedBody nvarchar(4000) --ntext
		, @EmoticonID int
		, @IsLocked bit
		, @IsSticky bit
		, @IsApproved bit
		, @StickyDate datetime
		, @PostType int
		, @PostMedia int
		, @PostDate datetime
		, @UserHostAddress nvarchar(32)
		, @PropertyNames nvarchar(4000) --ntext
		, @PropertyValues nvarchar(4000) --ntext
		, @SettingsID int
		, @IsTracked bit
		, @PostID int
		, @ThreadID int
		, @PostConfiguration int
		, @UpdateSectionStatistics bit
		, @UserTime datetime
		, @ApplicationPostType int
		, @PostName nvarchar(256)
		, @ThreadStatus int
		, @Points int
		, @PostDisplayName nvarchar(64)
		, @AutoApprove bit
	
		/* from cs_weblog_Post_Create */
		, @TitleUrl nvarchar(256)
		, @PostConfig int
		, @BlogPostType tinyint
		, @Categories nvarchar(4000)
		, @SpamScore int
		, @PostStatus int
	
	if @SpamPostID IS NOT NULL
	begin

		select
			@SourceProcedure = p.[SourceProcedure]
			, @SectionID = p.[SectionID]
			, @ParentID = p.[ParentID]
			, @AllowDuplicatePosts = p.[AllowDuplicatePosts]
			, @DuplicateIntervalInMinutes = p.[DuplicateIntervalInMinutes]
			, @Subject = p.[Subject]
			, @UserID = p.[UserID]
			, @PostAuthor = p.[PostAuthor]
			, @Body = p.[Body]
			, @FormattedBody = p.[FormattedBody]
			, @EmoticonID = p.[EmoticonID]
			, @IsLocked = p.[IsLocked]
			, @IsSticky = p.[IsSticky]
			, @IsApproved = p.[IsApproved]
			, @StickyDate = p.[StickyDate]
			, @PostType = p.[PostType]
			, @PostMedia = p.[PostMedia]
			, @PostDate = p.[PostDate]
			, @UserHostAddress = p.[UserHostAddress]
			, @PropertyNames = p.[PropertyNames]
			, @PropertyValues = p.[PropertyValues]
			, @SettingsID = p.[SettingsID]
			, @IsTracked = p.[IsTracked]
			, @ThreadID = p.[ThreadID]
			, @PostConfiguration = p.[PostConfiguration]
			, @UpdateSectionStatistics = p.[UpdateSectionStatistics]
			, @UserTime = p.[UserTime]
			, @ApplicationPostType = p.[ApplicationPostType]
			, @PostName = p.[PostName]
			, @ThreadStatus = p.[ThreadStatus]
			, @Points = p.[Points]
			, @PostDisplayName = p.[PostDisplayName]
			, @AutoApprove = p.[AutoApprove]
			, @TitleUrl = p.[TitleUrl]
			, @PostConfig = p.[PostConfig]
			, @BlogPostType = p.[BlogPostType]
			, @Categories = p.[Categories]
			, @SpamScore = p.[SpamScore]
			, @PostStatus = p.[PostStatus]
			, @PostID = NULL /* resetting the PostID */
		from
			[dbo].[cs_SpamPosts] p
		where
			p.[SpamPostID] = @SpamPostID

		if @SourceProcedure = N'cs_Post_CreateUpdate'
		begin

			select
				@IsApproved = 1 /* @IsApproved will be set to 1.  If someone is moving a post, it should be approved.  Perhaps there should be a flag to set this,  */

			execute @return_value = [dbo].[cs_Post_CreateUpdate]
				@SectionID = @SectionID
				, @ParentID = @ParentID
				, @AllowDuplicatePosts = @AllowDuplicatePosts
				, @DuplicateIntervalInMinutes = @DuplicateIntervalInMinutes
				, @Subject = @Subject
				, @UserID = @UserID
				, @PostAuthor = @PostAuthor
				, @Body = @Body
				, @FormattedBody = @FormattedBody
				, @EmoticonID = @EmoticonID
				, @IsLocked = @IsLocked
				, @IsSticky = @IsSticky
				, @IsApproved = @IsApproved
				, @StickyDate = @StickyDate
				, @PostType = @PostType
				, @PostMedia = @PostMedia
				, @PostDate = @PostDate
				, @UserHostAddress = @UserHostAddress
				, @PropertyNames = @PropertyNames
				, @PropertyValues = @PropertyValues
				, @SettingsID = @SettingsID
				, @IsTracked = @IsTracked
					, @PostID = @PostID output
				, @ThreadID = @ThreadID
				, @PostConfiguration = @PostConfiguration
				, @UpdateSectionStatistics = @UpdateSectionStatistics
				, @UserTime = @UserTime
				, @ApplicationPostType = @ApplicationPostType
				, @PostName = @PostName
				, @ThreadStatus = @ThreadStatus
				, @Points = @Points
				, @PostDisplayName = @PostDisplayName
				, @AutoApprove = @AutoApprove

		end
		else if @SourceProcedure = N'cs_weblog_Post_Create'
		begin

			select
				@IsApproved = 1 /* @IsApproved will be set to 1.  If someone is moving a post, it should be approved.  Perhaps there should be a flag to set this,  */
				, @PostStatus = @PostStatus & 0x7ffffffd /* ensure that PostStatus=2 (spam) is not set since this is how a post gets here */

			execute @return_value = [dbo].[cs_weblog_Post_Create]
				@SectionID = @SectionID
				, @ParentID = @ParentID
				, @AllowDuplicatePosts = @AllowDuplicatePosts
				, @DuplicateIntervalInMinutes = @DuplicateIntervalInMinutes
				, @Subject = @Subject
				, @UserID = @UserID
				, @PostAuthor = @PostAuthor
				, @Body = @Body
				, @FormattedBody = @FormattedBody
				, @EmoticonID = @EmoticonID
				, @IsLocked = @IsLocked
				, @IsSticky = @IsSticky
				, @IsApproved = @IsApproved
				, @IsTracked = @IsTracked
				, @StickyDate = @StickyDate
				, @PostType = @PostType
				, @PostMedia = @PostMedia
				, @PostDate = @PostDate
				, @UserTime = @UserTime
				, @UserHostAddress = @UserHostAddress
				, @PostName = @PostName
				, @TitleUrl = @TitleUrl
				, @PostConfig = @PostConfig
				, @BlogPostType = @BlogPostType
				, @Categories = @Categories
				, @PropertyNames = @PropertyNames
				, @PropertyValues = @PropertyValues
				, @SettingsID = @SettingsID
				, @SpamScore = @SpamScore
				, @PostStatus = @PostStatus
					, @PostID = @PostID output
			
		end
	end
	
	if @return_value = 0
	begin
	
		delete p from [dbo].[cs_SpamPosts] p
		where
			p.[SpamPostID] = @SpamPostID
	
	end
	
	return @return_value
end

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

GRANT EXECUTE ON [dbo].[cs_SpamPostReviveOne] TO [public]
GO

