SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SpamPostRevive]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SpamPostRevive]
GO

CREATE PROCEDURE [dbo].[cs_SpamPostRevive]
(
	@SettingsID int = null
	, @SectionID int = null
	, @ThreadID int = null
	, @RowCount int = null output
)
AS
begin

	SET NOCOUNT ON
	
	declare @ID bigint, @SpamPostID bigint, @TotalRowCount bigint

	declare @SpamPosts table (
		ID bigint identity(1, 1) not null primary key
		, SpamPostID bigint not null
		)

	select @ID = 1, @TotalRowCount = 0

	--We will allow movement at a SpamPostID level and a SettingsID, SectionID, ThreadID level.
	--The default is SpamPostID - if that is set, it overrides any thing else

	if @SettingsID IS NOT NULL AND @SectionID IS NOT NULL
	begin
	
		if @ThreadID IS NOT NULL
		begin
		
			/* Revive spam posts by Thread */
			insert into @SpamPosts ( [SpamPostID] )
			select p.[SpamPostID] from [dbo].[cs_SpamPosts] p
			where p.[SettingsID] = @SettingsID AND p.[SectionID] = @SectionID AND p.[ThreadID] = @ThreadID
		
		end
		else
		begin
		
			/* Revive spam posts by Section */
			insert into @SpamPosts ( [SpamPostID] )
			select p.[SpamPostID] from [dbo].[cs_SpamPosts] p
			where p.[SettingsID] = @SettingsID AND p.[SectionID] = @SectionID
		
		end
		
		while 1=1
		begin
			select @SpamPostID = (select p.[SpamPostID] from @SpamPosts p where p.[ID] = @ID)
			
			if @SpamPostID IS NULL break
			
			execute [dbo].[cs_SpamPostReviveOne] @SpamPostID = @SpamPostID, @RowCount = @RowCount output
			
			select
				@TotalRowCount = @TotalRowCount + @RowCount
				, @ID = @ID + 1
		end
	end
	
	set @RowCount = @TotalRowCount
	
	return 0

end

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

GRANT EXECUTE ON [dbo].[cs_SpamPostRevive] TO [public]
GO
