SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SpamPostDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SpamPostDelete]
GO

CREATE PROCEDURE [dbo].[cs_SpamPostDelete]
(
	@SpamPostID bigint = null
	, @SettingsID int = null
	, @SectionID int = null
	, @ThreadID int = null
	, @RowCount int = null output
)
AS
begin
	SET NOCOUNT ON
	
    --	We will allow movement at a SpamPostID level, a SettingsID, SectionID, ThreadID level, and SettingsID, SectionID
    --	The default is SpamPostID - if that is set, it overrides any thing else

	if @SpamPostID IS NOT NULL
	begin
	
		/* Remove a single spam post */
		delete p from [dbo].[cs_SpamPosts] p
		where p.[SpamPostID] = @SpamPostID
		
		set @RowCount = @@ROWCOUNT
	
	end
	else if @SettingsID IS NOT NULL AND @SectionID IS NOT NULL
	begin
	
		if @ThreadID IS NOT NULL
		begin
		
			/* Remove spam posts by Thread */
			delete p from [dbo].[cs_SpamPosts] p
			where p.[SettingsID] = @SettingsID AND p.[SectionID] = @SectionID AND p.[ThreadID] = @ThreadID
			
			set @RowCount = @@ROWCOUNT
		
		end
		else
		begin
		
			/* Remove spam posts by Section */
			delete p from [dbo].[cs_SpamPosts] p
			where p.[SettingsID] = @SettingsID AND p.[SectionID] = @SectionID
			
			set @RowCount = @@ROWCOUNT
		
		end
	end
	
	return 0
end

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

GRANT EXECUTE ON [dbo].[cs_SpamPostDelete] TO [public]
GO

