SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SpamPostArchive]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SpamPostArchive]
GO

CREATE PROCEDURE [dbo].[cs_SpamPostArchive]
(
	@SourceProcedure nvarchar(128)
	/* from cs_Post_CreateUpdate */
	, @SectionID int
	, @ParentID int
	, @AllowDuplicatePosts bit
	, @DuplicateIntervalInMinutes int
	, @Subject nvarchar(256)
	, @UserID int
	, @PostAuthor nvarchar(64)
	, @Body ntext
	, @FormattedBody ntext
	, @EmoticonID int
	, @IsLocked bit
	, @IsSticky bit
	, @IsApproved bit
	, @StickyDate datetime
	, @PostType int
	, @PostMedia int
	, @PostDate datetime
	, @UserHostAddress nvarchar(32)
	, @PropertyNames ntext
	, @PropertyValues ntext
	, @SettingsID int
	, @IsTracked bit
	, @PostID int
	, @ThreadID int
	, @PostConfiguration int
	, @UpdateSectionStatistics bit
	, @UserTime datetime
	, @ApplicationPostType int
	, @PostName nvarchar(256)
	, @ThreadStatus int
	, @Points int
	, @PostDisplayName nvarchar(64)
	, @AutoApprove bit

	/* from cs_weblog_Post_Create */
	, @TitleUrl nvarchar(256)
	, @PostConfig int
	, @BlogPostType tinyint
	, @Categories nvarchar(4000)
	, @SpamScore int
	, @PostStatus int
)
AS
begin
	SET NOCOUNT ON

	if @SourceProcedure IS NULL
	begin
		raiserror ( 'The parameter @SourceProcedure should not be NULL.', 16, 1 )
		return 1
	end
	
	if OBJECT_ID( @SourceProcedure ) IS NULL
	begin
		raiserror ( 'The parameter @SourceProcedure contains [%s] which is not currently a valid object in the database.', 16, 1, @SourceProcedure )
		return 2
	end
	
	select
		@PostDate = COALESCE( @PostDate, getdate() )
		, @UserTime = COALESCE( @UserTime, @PostDate )

	INSERT INTO [dbo].[cs_SpamPosts] (
		[SourceProcedure]
		, [SectionID], [ParentID], [AllowDuplicatePosts], [DuplicateIntervalInMinutes], [Subject], [UserID], [PostAuthor]
		, [Body], [FormattedBody], [EmoticonID], [IsLocked], [IsSticky], [IsApproved], [StickyDate]
		, [PostType], [PostMedia], [PostDate], [UserHostAddress], [PropertyNames], [PropertyValues], [SettingsID]
		, [IsTracked], [ThreadID], [PostConfiguration], [UpdateSectionStatistics], [UserTime], [ApplicationPostType]
		, [PostName], [ThreadStatus], [Points], [PostDisplayName], [AutoApprove], [TitleUrl], [PostConfig]
		, [BlogPostType], [Categories], [SpamScore], [PostStatus]
	) VALUES (
		@SourceProcedure
		, @SectionID, @ParentID, @AllowDuplicatePosts, @DuplicateIntervalInMinutes, @Subject, @UserID, @PostAuthor
		, @Body, @FormattedBody, @EmoticonID, @IsLocked, @IsSticky, @IsApproved, @StickyDate
		, @PostType, @PostMedia, @PostDate, @UserHostAddress, @PropertyNames, @PropertyValues, @SettingsID
		, @IsTracked, @ThreadID, @PostConfiguration, @UpdateSectionStatistics, @UserTime, @ApplicationPostType
		, @PostName, @ThreadStatus, @Points, @PostDisplayName, @AutoApprove, @TitleUrl, @PostConfig
		, @BlogPostType, @Categories, @SpamScore, @PostStatus
	)

end

GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO

GRANT EXECUTE ON [dbo].[cs_SpamPostArchive] TO [public]
GO

