SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Sections_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Sections_Get]
GO


CREATE PROCEDURE [dbo].[cs_Sections_Get]
(
	@SettingsID				int,
	@ApplicationType        smallint = null,
	@AllowInactive			bit = 0,
	@IncludePostTypeCounts	bit = 0,
	@sqlPopulate			ntext = null,
	@PageIndex				int = 0, 
	@PageSize				int = 2147483646,
	@IncludePageIndex		bit = 0,
	@IncludeMembers			bit = 0,
	@HubSectionID			int = 0,
	@TotalRecords			int = null output

)
AS
begin
	SET Transaction Isolation Level Read UNCOMMITTED
	
	DECLARE @PageLowerBound int
	DECLARE @PageUpperBound int
	DECLARE @RowsToReturn int
	DECLARE @TotalThreads int
	
	-- First set the rowcount
	SET @RowsToReturn = @PageSize * (@PageIndex + 1)
	
	
	
	
	-- Set the page bounds
	SET @PageLowerBound = @PageSize * @PageIndex
	SET @PageUpperBound = @PageLowerBound + @PageSize + 1
	
	
	
	-- Create a temp table to store the select results
	CREATE TABLE #PageIndex 
	(
		IndexID int IDENTITY (1, 1) NOT NULL,
		SectionID int not null
	)
	 
	
	if @sqlPopulate is not null
	BEGIN
		INSERT INTO #PageIndex (SectionID)
		EXEC sp_executesql @sqlPopulate
	END
	ELSE
	BEGIN
		IF @ApplicationType = 11 AND @HubSectionID = 0
		BEGIN
			INSERT INTO #PageIndex (SectionID)
			SELECT SectionID from cs_Sections where SettingsID = @SettingsID AND (ApplicationType = @ApplicationType OR @ApplicationType is null)
		END
		ELSE
		BEGIN
			INSERT INTO #PageIndex (SectionID)
			SELECT SectionID from cs_Sections where SettingsID = @SettingsID AND (ApplicationType = @ApplicationType OR @ApplicationType is null) AND HubSectionID = @HubSectionID
		END
	END
	
	SET @TotalRecords = @@rowcount
	
	-- if an index is to be created, it should come after the insertion
	--CREATE INDEX page_index ON #PageIndex(IndexID)
	
	SET ROWCOUNT @RowsToReturn
	
	
	-- Return all the sections
	SELECT  
		S.SectionID, S.SettingsID, S.IsActive, S.ParentID, S.GroupID, S.Name, S.NewsgroupName, 
		S.Description, S.DateCreated, S.Url, S.IsModerated, S.DaysToView, S.SortOrder, S.TotalPosts, 
		S.TotalThreads, S.DisplayMask, S.EnablePostStatistics, S.EnablePostPoints, S.EnableAnonymousPosting, 
		S.MostRecentPostID, S.MostRecentThreadID, S.MostRecentThreadReplies, S.MostRecentPostSubject, 
		S.MostRecentPostAuthor, S.MostRecentPostAuthorID, S.MostRecentPostDate, S.PostsToModerate, S.ForumType, 
		S.IsSearchable, S.ApplicationType, S.ApplicationKey, S.Path, S.PropertyNames as SectionPropertyNames, 
		S.PropertyValues as SectionPropertyValues, S.DefaultLanguage, S.DiskUsage, S.IsPublic, S.HubSectionID, 
		S.IsCommunityAggregated, W.MostRecentPostID as WeblogMostRecentPostID, 
		W.MostRecentPostDate as WeblogMostRecentPostDate, W.MostRecentPostName as WeblogMostRecentPostName, 
		W.MostRecentPostAuthorID as WeblogMostRecentPostAuthorID, W.MostRecentPostAuthor as WeblogMostRecentPostAuthor, 
		W.MostRecentPostSubject as WeblogMostRecentPostSubject, W.MostRecentArticleID, W.MostRecentArticleDate, 
		W.MostRecentArticleName, W.MostRecentArticleAuthorID, W.MostRecentArticleAuthor, W.MostRecentArticleSubject, 
		W.PostCount, W.ArticleCount, W.CommentCount, W.TrackbackCount
	FROM
		#PageIndex jPI
		INNER JOIN cs_Sections S on S.SettingsID = @SettingsID AND S.SectionID = jPI.SectionID
		LEFT OUTER JOIN cs_weblog_Weblogs W on S.SectionID = W.SectionID
	WHERE
		--(IsActive = 1 OR 1 = @AllowInactive) AND
		(ApplicationType = @ApplicationType or @ApplicationType is null) AND
		jPI.IndexID > @PageLowerBound AND 
		jPI.IndexID < @PageUpperBound
	ORDER BY
		IndexID	-- this is the ordering system we're using populated from the @sqlPopulate
	
	
	--Clear the rowcount
	SET ROWCOUNT 0
	
	--Declare @AnonID int
	--exec cs_GetAnonymousUserID @SettingsID, @AnonID output
	
	exec cs_Section_Permissions_Get @SettingsID, 0, @ApplicationType
	
	--Return the counts of each post type
	IF @IncludePostTypeCounts > 0
	BEGIN
		
		SELECT 
			F.ApplicationKey, P.ApplicationPostType, Count(*) as PostCount
		FROM 
			#PageIndex jPI
			INNER JOIN cs_Sections F on F.SettingsID = @SettingsID AND F.SectionID = jPI.SectionID
			INNER JOIN cs_Posts P on F.SettingsID = P.SettingsID AND F.SectionID = P.SectionID
		WHERE 
			jPI.IndexID > @PageLowerBound AND 
			jPI.IndexID < @PageUpperBound AND
			(F.ApplicationType = @ApplicationType or @ApplicationType is null)
		GROUP BY 
			F.ApplicationKey, P.ApplicationPostType, jPI.IndexID
		ORDER BY
			IndexID	-- this is the ordering system we're using populated from the @sqlPopulate
		
	END
	
	SET ROWCOUNT 0
	
  IF @IncludeMembers = 1
  BEGIN

	SELECT
		SM.SectionID,
		SM.UserID,
		SM.MembershipType,
		SM.DateAdded,
		S.ApplicationType
	FROM
		#PageIndex jPI
		INNER JOIN dbo.cs_SectionMembers SM on SM.SectionID = jPI.SectionID
		INNER JOIN cs_Sections S on S.SettingsID = @SettingsID AND S.SectionID = jPI.SectionID
	WHERE
		jPI.IndexID > @PageLowerBound
		AND jPI.IndexID < @PageUpperBound
	ORDER BY
		SM.SectionID, SM.MembershipType

  End
	
	If @IncludePageIndex = 1 
	BEGIN
		SELECT IndexID, SectionID from #PageIndex ORDER BY IndexID
	END
	
	DROP TABLE #PageIndex
end
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_Sections_Get]  TO [public]
GO

