-- exec cs_Section_Permissions_Get 1000, 0
SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[cs_Section_Permissions_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Section_Permissions_Get]
GO

create procedure [dbo].[cs_Section_Permissions_Get]
(
	@SettingsID int,
	@SectionID int = 0,
	@ApplicationType smallint,
	@AllRoles ntext = NULL
)
AS
begin
	SET Transaction Isolation Level Read UNCOMMITTED
	
	IF ( @SectionID = 0 )
	begin
		-- Return product permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			GroupID = -1,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)),
			P.ApplicationType 
		FROM
			cs_ProductPermissions P
		WHERE 
			(P.ApplicationType = @ApplicationType or @ApplicationType is null) AND
			P.SettingsID = @SettingsID
	
		UNION ALL
	
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			P.GroupID, 
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)),  
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)),  
			G.ApplicationType 
		FROM 
			cs_GroupPermissions P
		INNER JOIN
			cs_Groups G
			ON P.GroupID = G.GroupID AND P.SettingsID = G.SettingsID
		WHERE
			G.SettingsID = @SettingsID AND
			(G.ApplicationType = @ApplicationType or @ApplicationType is null)
		
		UNION ALL
	
		-- Return section permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 0), 
			P.SectionID,
			GroupID = -1, 
			F.ApplicationKey,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)),  
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)),  
			F.ApplicationType
		FROM 
			cs_SectionPermissions P
		INNER JOIN
			cs_Sections F
			ON P.SectionID = F.SectionID AND P.SettingsID = F.SettingsID
		WHERE
			F.SettingsID = @SettingsID AND
			(F.ApplicationType = @ApplicationType or @ApplicationType is null)
		order by Implied asc, SectionID, GroupID desc
	
	end
	ELSE IF (@SectionID > 0)
	begin
		
		-- Return product permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			GroupID = -1,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)), 
			P.ApplicationType 
		FROM
			cs_ProductPermissions P
		WHERE 
			(P.ApplicationType = @ApplicationType or @ApplicationType is null) AND
			P.SettingsID = @SettingsID
	
		UNION ALL

		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			P.GroupID,
			ApplicationKey = null,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)), 
			S.ApplicationType 
		FROM
			cs_GroupPermissions P
			INNER JOIN cs_Sections S on S.SectionID = @SectionID AND S.GroupID = P.GroupID
		WHERE 
			P.SettingsID = @SettingsID

		UNION ALL
		
		-- Return section permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 0), 
			P.SectionID,
			F.GroupID,
			F.ApplicationKey,
			P.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)),  
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)),  
			F.ApplicationType 
		FROM 
			cs_SectionPermissions P
		INNER JOIN
			cs_Sections F
			ON P.SectionID = F.SectionID AND P.SettingsID = F.SettingsID
		WHERE
			F.SettingsID = @SettingsID AND
			F.SectionID = @SectionID  AND
			(F.ApplicationType = @ApplicationType or @ApplicationType is null)
		order by Implied asc, SectionID, GroupID DESC
	END 
    ELSE BEGIN
	
	    DECLARE @Roles		table(RoleID uniqueidentifier NOT NULL PRIMARY KEY)
	    DECLARE @Num		int
	    DECLARE @Pos		int
	    DECLARE @NextPos	int
	    DECLARE @guid		nvarchar(256)
	
	    DECLARE @textpos  int --our chunks position in the ntext
	    DECLARE @chunklen smallint
	    DECLARE @chunk   nvarchar(4000)
	    DECLARE @delimiter nvarchar(1)
	    DECLARE @leftover nvarchar(4000)
	
		SET @delimiter = N','
		SET @Num = 0
		SET @textpos = 1
		SET @leftover = ''
	
		WHILE @textpos <= DATALENGTH(@AllRoles) /2
		BEGIN
	
			SET @chunklen = 4000 - DATALENGTH(@leftover) /2
			SET @chunk = ltrim(@leftover + substring(@AllRoles, @textpos, @chunklen))
			SET @textpos = @textpos + @chunklen
	
			SET @Pos = 1 
	
			WHILE(@Pos <= DATALENGTH(@chunk))
			BEGIN
				SELECT @NextPos = CHARINDEX(@delimiter, @chunk,  @Pos)
				IF (@NextPos = 0 OR @NextPos IS NULL)
				BEGIN
					--break us from the loop
					SELECT @NextPos = DATALENGTH(@chunk) + 1
					--set the leftover string to use again in next iter
					SET @leftover = LOWER(RTRIM(LTRIM(SUBSTRING(@chunk, @Pos, @NextPos - @Pos))))
				END
				ELSE
				BEGIN
					SELECT @guid = LOWER(RTRIM(LTRIM(SUBSTRING(@chunk, @Pos, @NextPos - @Pos))))
	
					INSERT INTO @Roles VALUES (CONVERT(uniqueidentifier, @guid))
	
					SET @Num = @Num + 1
				END
	
				SELECT @Pos = @NextPos+1
			END
	
			IF(@Pos = DATALENGTH(@chunk))
				SET @leftover = ''
		END
	
		INSERT INTO @Roles VALUES (CONVERT(uniqueidentifier, @leftover))
	
	
		-- Return product permissions
		SELECT
			P.SettingsID, 
			Implied = convert(bit, 1), 
			SectionID = -1,
			GroupID = -1,
			R.RoleID, 
			AllowMask = convert(bigint, coalesce(P.AllowMask, 0x00)), 
			DenyMask = convert(bigint, coalesce(P.DenyMask, 0x00)),
			P.ApplicationType 
		FROM
			@Roles R
			left outer join cs_ProductPermissions P on R.RoleID = P.RoleID and (P.ApplicationType = @ApplicationType or @ApplicationType is null)and P.SettingsID = @SettingsID
	END
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

grant execute on [dbo].[cs_Section_Permissions_Get] to public
go