SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_Section_Permission_CreateUpdateDelete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_Section_Permission_CreateUpdateDelete]
GO

CREATE  procedure [dbo].cs_Section_Permission_CreateUpdateDelete
(
	@SettingsID 	int,
	@SectionID 	int,
	@GroupID 	int,
	@RoleID		uniqueidentifier,
	@Action		int,
	@AllowMask	bigint,
	@DenyMask	bigint,
	@ApplicationType smallint
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN

-- Create
IF @Action = 0
BEGIN

	IF( @SectionID <> -1) 
	begin
		-- Check if an entry already exists
		IF EXISTS (SELECT SectionID FROM cs_SectionPermissions WHERE SectionID = @SectionID AND RoleID = @RoleID )
			exec cs_Section_Permission_CreateUpdateDelete @SettingsID, @SectionID, @GroupID, @RoleID, 1, @AllowMask, @DenyMask, @ApplicationType
		ELSE
			INSERT INTO 
				cs_SectionPermissions (SettingsID, SectionID, RoleID, AllowMask, DenyMask)
			VALUES	(
					@SettingsID,
					@SectionID,
					@RoleID,
					@AllowMask,
					@DenyMask
				)
	
		if not exists( select * from cs_ProductPermissions where SettingsID = @SettingsID and RoleID = @RoleID and ApplicationType = @ApplicationType)
			insert into cs_ProductPermissions ( SettingsID, RoleID, AllowMask, DenyMask, ApplicationType )
				values( @SettingsID, @RoleID, 0x0, 0x0, @ApplicationType )

		select @GroupID = GroupID from cs_Sections S where S.SectionID = @SectionID and S.SettingsID = @SettingsID
			
		if not exists( select * from cs_GroupPermissions where SettingsID = @SettingsID and RoleID = @RoleID and GroupID = @GroupID)
			insert into cs_GroupPermissions ( SettingsID, RoleID, AllowMask, DenyMask, GroupID )
				values( @SettingsID, @RoleID, 0x0, 0x0, @GroupID )
				
		--reindex the posts
		exec cs_Posts_ReindexBySection @SectionID, @SettingsID
	end
	ELSE IF (@GroupID <> -1)
	begin
		IF EXISTS (SELECT GroupID FROM cs_GroupPermissions WHERE GroupID = @GroupID AND RoleID = @RoleID )
			exec cs_Section_Permission_CreateUpdateDelete @SettingsID, @SectionID, @GroupID, @RoleID, 1, @AllowMask, @DenyMask, @ApplicationType
		ELSE
			INSERT INTO 
				cs_GroupPermissions (SettingsID, GroupID, RoleID, AllowMask, DenyMask)
			VALUES	(
					@SettingsID,
					@GroupID,
					@RoleID,
					@AllowMask,
					@DenyMask
				)

		if not exists( select * from cs_ProductPermissions where SettingsID = @SettingsID and RoleID = @RoleID and ApplicationType = @ApplicationType)
			insert into cs_ProductPermissions ( SettingsID, RoleID, AllowMask, DenyMask, ApplicationType )
				values( @SettingsID, @RoleID, 0x0, 0x0, @ApplicationType )

		--reindex the posts
		exec cs_Posts_ReindexByGroup @GroupID, @SettingsID
	end
	ELSE
	begin
		insert into cs_ProductPermissions ( SettingsID, RoleID, AllowMask, DenyMask, ApplicationType )
			values( @SettingsID, @RoleID, @AllowMask, @DenyMask, @ApplicationType )
	end
END
-- UPDATE
ELSE IF @Action = 1
BEGIN
	
	IF ( @SectionID <> -1 ) 
	begin
		IF NOT EXISTS (SELECT SectionID FROM cs_SectionPermissions WHERE SectionID = @SectionID AND RoleID = @RoleID and SettingsID = @SettingsID )
			INSERT INTO 
				cs_SectionPermissions (SettingsID, SectionID, RoleID, AllowMask, DenyMask)
			VALUES	(
					@SettingsID,
					@SectionID,
					@RoleID,
					@AllowMask,
					@DenyMask
				)
		ELSE
			UPDATE
				cs_SectionPermissions 
			SET
				AllowMask	= @AllowMask,
				DenyMask	= @DenyMask
			WHERE
				SectionID = @SectionID AND
				RoleID = @RoleID AND SettingsID = @SettingsID

		if not exists( select * from cs_ProductPermissions where SettingsID = @SettingsID and RoleID = @RoleID and ApplicationType = @ApplicationType)
			insert into cs_ProductPermissions ( SettingsID, RoleID, AllowMask, DenyMask, ApplicationType )
				values( @SettingsID, @RoleID, 0x0, 0x0, @ApplicationType )

		select @GroupID = GroupID from cs_Sections S where S.SectionID = @SectionID and S.SettingsID = @SettingsID
			
		if not exists( select * from cs_GroupPermissions where SettingsID = @SettingsID and RoleID = @RoleID and GroupID = @GroupID)
			insert into cs_GroupPermissions ( SettingsID, RoleID, AllowMask, DenyMask, GroupID )
				values( @SettingsID, @RoleID, 0x0, 0x0, @GroupID )
	end
	ELSE IF (@GroupID <> -1)
	begin
		IF NOT EXISTS (SELECT GroupID FROM cs_GroupPermissions WHERE GroupID = @GroupID AND RoleID = @RoleID )
			INSERT INTO 
				cs_GroupPermissions (SettingsID, GroupID, RoleID, AllowMask, DenyMask)
			VALUES	(
					@SettingsID,
					@GroupID,
					@RoleID,
					@AllowMask,
					@DenyMask
				)
		ELSE
			UPDATE
				cs_GroupPermissions
			SET
				AllowMask	= @AllowMask,
				DenyMask	= @DenyMask
			WHERE
				GroupID = @GroupID AND
				RoleID = @RoleID AND
				SettingsID = @SettingsID

		if not exists( select * from cs_ProductPermissions where SettingsID = @SettingsID and RoleID = @RoleID and ApplicationType = @ApplicationType)
			insert into cs_ProductPermissions ( SettingsID, RoleID, AllowMask, DenyMask, ApplicationType )
				values( @SettingsID, @RoleID, 0x0, 0x0, @ApplicationType )	
	end
	ELSE
	begin
		if not exists( select * from cs_ProductPermissions where RoleID = @RoleID and SettingsID = @SettingsID and ApplicationType = @ApplicationType )
			exec cs_Section_Permission_CreateUpdateDelete @SettingsID, @SectionID, @GroupID, @RoleID, 0, @AllowMask, @DenyMask, @ApplicationType
		else
			UPDATE
				cs_ProductPermissions 
			SET
				AllowMask	= @AllowMask,
				DenyMask	= @DenyMask
			WHERE
				RoleID = @RoleID and SettingsID = @SettingsID and ApplicationType = @ApplicationType
	end

END
ELSE IF @Action = 2
BEGIN
	IF( @SectionID <> -1 )
		DELETE cs_SectionPermissions WHERE SectionID = @SectionID AND RoleID = @RoleID and SettingsID = @SettingsID
	ELSE IF (@GroupID <> -1)
		DELETE cs_GroupPermissions WHERE GroupID = @GroupID AND RoleID = @RoleID AND SettingsID = @SettingsID
	ELSE
	begin
		DELETE cs_SectionPermissions WHERE RoleID = @RoleID and SettingsID = @SettingsID
		DELETE cs_GroupPermissions WHERE RoleID = @RoleID AND SettingsID = @SettingsID
		DELETE cs_ProductPermissions WHERE RoleID = @RoleID and SettingsID = @SettingsID and ApplicationType = @ApplicationType
	end
	
END

END


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE ON [dbo].[cs_Section_Permission_CreateUpdateDelete] TO PUBLIC
GO