SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SectionMembers_Get]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SectionMembers_Get]
GO

CREATE procedure dbo.cs_SectionMembers_Get
(
	@SectionID			int = NULL,
	@UserID				int = NULL,
	@MembershipType		int = NULL
)
AS
	SET NOCOUNT ON
	SET Transaction Isolation Level Read UNCOMMITTED


		SELECT
			SM.SectionID,
			SM.UserID,
			SM.MembershipType,
			SM.DateAdded,
			S.ApplicationType
		FROM
			cs_SectionMembers SM
			join cs_Sections S on S.SectionID = SM.SectionID and S.IsActive = 1
		WHERE
		(SM.SectionID = @SectionID OR @SectionID IS NULL) AND
		(SM.UserID = @UserID OR @UserID IS NULL) AND
		(SM.MembershipType & @MembershipType = SM.MembershipType OR @MembershipType IS NULL)


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_SectionMembers_Get] to public
