SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SectionMembers_Add]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SectionMembers_Add]
GO

CREATE PROCEDURE dbo.cs_SectionMembers_Add
(
	@SectionID			int,
	@UserID				int,
	@MembershipType		int,
	@DateAdded datetime OUTPUT
)
AS
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED


			UPDATE cs_SectionMembers
				Set MembershipType = @MembershipType
			WHERE
				SectionID = @SectionID AND UserID = @UserID

      IF @@ROWCOUNT = 0
      BEGIN
        INSERT INTO cs_SectionMembers
          (SectionID, UserID, MembershipType)
        VALUES
          (@SectionID, @UserID, @MembershipType)
      END
			SELECT @DateAdded = [DateAdded] from cs_SectionMembers WHERE SectionID = @SectionID AND UserID = @UserID AND MembershipType = @MembershipType

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT EXECUTE on [dbo].[cs_SectionMembers_Add] to public
