SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[cs_SearchBarrel_Search]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[cs_SearchBarrel_Search]
GO
CREATE PROCEDURE [dbo].[cs_SearchBarrel_Search] (
	@SearchSQL NText,
	@PageIndex int = 0,
	@PageSize int = 25,
	@SettingsID int
)
AS
BEGIN

	SET Transaction Isolation Level Read UNCOMMITTED

	DECLARE @StartTime datetime
		, @RowsToReturn int
		, @PageLowerBound int
		, @PageUpperBound int
		, @Count int
		, @TotalRecords int

	-- Used to calculate cost of query
	SET @StartTime = GetDate()

	-- Set the rowcount
	SET @RowsToReturn = @PageSize * (@PageIndex + 1)
	--SET ROWCOUNT @RowsToReturn

	-- Calculate the page bounds
	SET @PageLowerBound = @PageSize * @PageIndex
	SET @PageUpperBound = @PageLowerBound + @PageSize + 1

	-- Create a temp table to store the results in
	CREATE TABLE #SearchResults
	(
		IndexID int IDENTITY (1, 1) NOT NULL primary key clustered,
		PostID int not null,
		SectionID int not null,
		Weight int,
		PostDate datetime
	)

	-- Fill the temp table
	INSERT INTO #SearchResults (PostID, SectionID, Weight, PostDate)
	exec sp_executesql @SearchSQL

	SET @TotalRecords = @@rowcount

	SET ROWCOUNT @RowsToReturn

	-- SELECT actual search results from this table
	SELECT
		P.PostID, P.ThreadID, P.ParentID, P.PostAuthor, P.UserID, P.SectionID, P.Subject, P.PostDate,
		P.FormattedBody, P.IPAddress, P.PostType, P.SettingsID, P.UserTime,
		P.ApplicationPostType, P.PostName, P.UserTime,
		COALESCE(pa.[FileName], '') AS AttachmentFilename,
		S.ApplicationKey, S.GroupID, S.ApplicationType, S.[Name] as SectionName, S.HubSectionID
	FROM 
		cs_Posts P
	INNER JOIN
		cs_Sections S ON P.SettingsID = S.SettingsID AND P.SectionID = S.SectionID
	INNER JOIN
		#SearchResults R ON R.PostID = P.PostID
	LEFT OUTER JOIN
		cs_PostAttachments pa ON pa.PostID = P.PostID
	WHERE
		S.SettingsID = @SettingsID AND
		R.IndexID > @PageLowerBound AND
		R.IndexID < @PageUpperBound
	Order By IndexID

	DROP Table #SearchResults

	Select @TotalRecords

	SELECT Duration = GetDate() - @StartTime

END
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

GRANT  EXECUTE  ON [dbo].[cs_SearchBarrel_Search]  TO [public]
GO

